/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.math;

public class UUIDRangeSplitter {
    private static final double HEX_DIGIT_FACTOR = 0.0625;
    private static final double EXT_HEX_DIGIT_FACTOR = 0.045454545454545456;
    private final double shardSize;

    public UUIDRangeSplitter(int shardsCount) {
        this.shardSize = 1.0 / (double)shardsCount;
    }

    public int getShardFor(String uuid) {
        double res = 0.0;
        double w = 0.045454545454545456;
        double wm = 0.045454545454545456;
        for (int i = 0; i < uuid.length(); ++i) {
            char c = uuid.charAt(i);
            if (c == '-') continue;
            int d = c - 48;
            if (d <= 9) {
                res += (double)d * w;
            } else {
                d = c - 65;
                res = d <= 5 ? (res += (double)(10 + d) * w) : (res += (double)(10 + (wm == 0.0625 ? 0 : 6) + (c - 97)) * w);
                wm = 0.0625;
            }
            int ind = (int)(res / this.shardSize);
            if (ind == (int)((res + w) / this.shardSize)) {
                return ind;
            }
            w *= wm;
        }
        return (int)(1.0 / this.shardSize);
    }
}

