/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;

public class MonitoringTree
implements JsonMonitorable {
    private ConcurrentHashMap<String, JsonMonitorable> roots = new ConcurrentHashMap();

    public void addRoot(String id, JsonMonitorable monitorable) {
        this.roots.put(id, monitorable);
    }

    public JSONObject get(String path, Set<String> excludeSet) {
        JSONObject res;
        if (path.contains("*") || path.contains("+")) {
            res = new JSONObject();
            this.get(this, res, path, false, false, excludeSet);
        } else {
            res = this.getSimple(this, path, excludeSet);
        }
        return res;
    }

    private JSONObject getSimple(JsonMonitorable mon, String path, Set<String> excludeSet) {
        StringTokenizer st = new StringTokenizer(path, ".");
        boolean truncate = false;
        while (st.hasMoreTokens()) {
            Map<String, ? extends JsonMonitorable> children;
            String token = st.nextToken();
            if (excludeSet.contains(token)) {
                return new JSONObject();
            }
            if (token.endsWith("!")) {
                truncate = true;
                token = token.substring(0, token.length() - 1);
            }
            if ((mon = (children = mon.getChildren()).get(token)) == null) {
                return new JSONObject();
            }
            if (!truncate) continue;
            break;
        }
        if (truncate) {
            return mon.getOwnMetrics();
        }
        return MonitoringTree.getAsJson(mon);
    }

    public JSONObject get(String path) {
        return this.get(path, Collections.emptySet());
    }

    public JSONObject getAll() {
        return MonitoringTree.getAsJson(this);
    }

    public JSONObject getInventory() {
        return MonitoringTree.getInventory(this);
    }

    public static JSONObject getAsJson(JsonMonitorable monitorable) {
        JSONObject res = monitorable.getOwnMetrics();
        for (Map.Entry<String, ? extends JsonMonitorable> entry : monitorable.getChildren().entrySet()) {
            res.put((Object)entry.getKey(), (Object)MonitoringTree.getAsJson(entry.getValue()));
        }
        return res;
    }

    public static JSONObject getInventory(JsonMonitorable monitorable) {
        Map<String, ? extends JsonMonitorable> children = monitorable.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        JSONObject res = new JSONObject();
        for (Map.Entry<String, ? extends JsonMonitorable> entry : children.entrySet()) {
            res.put((Object)entry.getKey(), (Object)MonitoringTree.getInventory(entry.getValue()));
        }
        return res;
    }

    @Override
    public JSONObject getOwnMetrics() {
        return new JSONObject();
    }

    public Map<String, JsonMonitorable> getChildren() {
        return this.roots;
    }

    private void get(JsonMonitorable monitorable, JSONObject outputNode, String pathSpec, boolean includeOwnMetrics, boolean truncate, Set<String> excludeSet) {
        String pathSuffix;
        String token;
        int dotInd = pathSpec.indexOf(46);
        if (dotInd != -1) {
            token = pathSpec.substring(0, dotInd);
            pathSuffix = pathSpec.substring(dotInd + 1);
        } else {
            token = pathSpec;
            pathSuffix = "";
        }
        if (includeOwnMetrics) {
            outputNode.putAll((Map)monitorable.getOwnMetrics());
        }
        if (truncate) {
            return;
        }
        truncate = token.endsWith("!");
        if (truncate) {
            token = token.substring(0, token.length() - 1);
        }
        if (includeOwnMetrics = token.endsWith("+")) {
            token = token.substring(0, token.length() - 1);
        }
        includeOwnMetrics |= pathSuffix.isEmpty();
        if (pathSuffix.isEmpty()) {
            pathSuffix = "*+";
        }
        if (token.equals("*")) {
            for (Map.Entry<String, ? extends JsonMonitorable> childEntry : monitorable.getChildren().entrySet()) {
                JsonMonitorable child = childEntry.getValue();
                JSONObject childNode = new JSONObject();
                String childName = childEntry.getKey();
                if (excludeSet.contains(childName)) continue;
                outputNode.put((Object)childName, (Object)childNode);
                this.get(child, childNode, pathSuffix, includeOwnMetrics, truncate, excludeSet);
            }
        } else {
            JsonMonitorable child = monitorable.getChildren().get(token);
            if (child == null || excludeSet.contains(token)) {
                return;
            }
            JSONObject childNode = new JSONObject();
            outputNode.put((Object)token, (Object)childNode);
            outputNode = childNode;
            this.get(child, outputNode, pathSuffix, includeOwnMetrics, truncate, excludeSet);
        }
    }
}

