/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;

public class SystemHealthMonitorable
implements JsonMonitorable {
    private final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

    @Override
    public JSONObject getOwnMetrics() {
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        JSONObject res = new JSONObject();
        res.put((Object)"heap", (Object)SystemHealthMonitorable.getMemUsage(this.memBean.getHeapMemoryUsage()));
        res.put((Object)"disk", (Object)SystemHealthMonitorable.getDiskUsage());
        res.put((Object)"nonHeap", (Object)SystemHealthMonitorable.getMemUsage(this.memBean.getNonHeapMemoryUsage()));
        res.put((Object)"gc", (Object)SystemHealthMonitorable.getGCData(gcBeans));
        res.put((Object)"processorsCount", (Object)this.osBean.getAvailableProcessors());
        res.put((Object)"loadAvg", (Object)this.osBean.getSystemLoadAverage());
        res.put((Object)"upTime", (Object)this.runtimeMXBean.getUptime());
        res.put((Object)"threadsCount", (Object)this.threadMXBean.getThreadCount());
        res.put((Object)"threadsStarted", (Object)this.threadMXBean.getTotalStartedThreadCount());
        res.put((Object)"tomcat", (Object)SystemHealthMonitorable.getTomcatData());
        res.put((Object)"memAfterGC", (Object)this.getMemPoolsData(memPools));
        return res;
    }

    private JSONObject getMemPoolsData(List<MemoryPoolMXBean> memPools) {
        JSONObject res = new JSONObject();
        for (MemoryPoolMXBean pool : memPools) {
            MemoryUsage collectionUsage = pool.getCollectionUsage();
            JSONObject details = null;
            if (collectionUsage != null) {
                details = SystemHealthMonitorable.getMemUsage(collectionUsage);
            }
            res.put((Object)pool.getName(), (Object)details);
        }
        return res;
    }

    private static JSONArray getGCData(List<GarbageCollectorMXBean> gcBeans) {
        JSONArray arr = new JSONArray();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            JSONObject gc = new JSONObject();
            gc.put((Object)"name", (Object)gcBean.getName());
            gc.put((Object)"collectionsCount", (Object)gcBean.getCollectionCount());
            gc.put((Object)"collectionTime", (Object)gcBean.getCollectionTime());
            gc.put((Object)"memPools", (Object)Arrays.toString(gcBean.getMemoryPoolNames()));
            arr.add((Object)gc);
        }
        return arr;
    }

    private static JSONObject getMemUsage(MemoryUsage memUsage) {
        JSONObject res = new JSONObject();
        res.put((Object)"init", (Object)memUsage.getInit());
        res.put((Object)"committed", (Object)memUsage.getCommitted());
        res.put((Object)"used", (Object)memUsage.getUsed());
        res.put((Object)"max", (Object)memUsage.getMax());
        return res;
    }

    private static JSONArray getDiskUsage() {
        JSONArray res = new JSONArray();
        for (File root : File.listRoots()) {
            JSONObject rootJson = new JSONObject();
            rootJson.put((Object)"name", (Object)root.getAbsolutePath());
            rootJson.put((Object)"usagePerc", (Object)(100.0 - (double)root.getFreeSpace() * 100.0 / (double)root.getTotalSpace()));
            res.add((Object)rootJson);
        }
        return res;
    }

    private static JSONObject getTomcatData() {
        JSONObject res = new JSONObject();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanPattern = new ObjectName("Catalina:type=ThreadPool,name=*");
            Set<ObjectInstance> beans = mbs.queryMBeans(beanPattern, null);
            for (ObjectInstance inst : beans) {
                ObjectName beanName = inst.getObjectName();
                JSONObject poolJs = new JSONObject();
                String name = (String)mbs.getAttribute(beanName, "name");
                int currThreadsCount = (Integer)mbs.getAttribute(beanName, "currentThreadCount");
                int currThreadsBusy = (Integer)mbs.getAttribute(beanName, "currentThreadsBusy");
                int maxThreadsCount = (Integer)mbs.getAttribute(beanName, "maxThreads");
                long connectionsCount = (Long)mbs.getAttribute(beanName, "connectionCount");
                int maxConnections = (Integer)mbs.getAttribute(beanName, "maxConnections");
                int maxKeepAliveReq = (Integer)mbs.getAttribute(beanName, "maxKeepAliveRequests");
                int keepAliveTO = (Integer)mbs.getAttribute(beanName, "keepAliveTimeout");
                poolJs.put((Object)"currentThreadCount", (Object)currThreadsCount);
                poolJs.put((Object)"currentThreadBusy", (Object)currThreadsBusy);
                poolJs.put((Object)"maxThreads", (Object)maxThreadsCount);
                poolJs.put((Object)"connections", (Object)connectionsCount);
                poolJs.put((Object)"maxConnections", (Object)maxConnections);
                poolJs.put((Object)"maxKeepAliveRequests", (Object)maxKeepAliveReq);
                poolJs.put((Object)"keepAliveTimeout", (Object)keepAliveTO);
                res.put((Object)name, (Object)poolJs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }
}

