/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Map;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.collectors.ActionStatsCollector;

public abstract class AbstractActionStatsCollector<E extends Enum<E>>
implements ActionStatsCollector<E> {
    private final ThreadLocal<Long> actionTrackingTL = new ThreadLocal();
    protected final Class<E> categoriesEnumClass;

    public AbstractActionStatsCollector(Class<E> categoriesEnumClass) {
        this.categoriesEnumClass = categoriesEnumClass;
    }

    @Override
    public void start() {
        this.actionTrackingTL.set(System.nanoTime());
        this.innerStart();
    }

    @Override
    public long duration() {
        Long startTime = this.actionTrackingTL.get();
        return AbstractActionStatsCollector.calcDuration(startTime, System.nanoTime());
    }

    @Override
    public long end(E category) {
        Long startTime = this.actionTrackingTL.get();
        if (startTime == null) {
            throw new IllegalStateException("end(..) called without a previous call to start()");
        }
        return this.end(category, startTime);
    }

    public long end(E category, long startTime) {
        long currTime = System.nanoTime();
        long duration = AbstractActionStatsCollector.calcDuration(startTime, currTime);
        this.innerEnd(category, duration);
        this.actionTrackingTL.set(null);
        return duration;
    }

    protected abstract void innerStart();

    protected abstract void innerEnd(E var1, long var2);

    @Override
    public JSONObject getOwnMetrics() {
        return this.getAll().getOwnMetrics();
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        return this.getAll().getChildren();
    }

    private static long calcDuration(long startTime, long endTime) {
        return Math.round((double)(endTime - startTime) / 1000.0);
    }
}

