/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.JsonMonitorableWrapper;
import org.pipecraft.infra.monitoring.collectors.ActionStats;

public class ActionStatsMap<E extends Enum<E>>
implements JsonMonitorable {
    private int runningCount;
    private int totalCompletedCount;
    private final EnumMap<E, ActionStats> statsPerCat;

    public ActionStatsMap(Class<E> enumType) {
        this.statsPerCat = new EnumMap(enumType);
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public int getTotalCompletedCount() {
        return this.totalCompletedCount;
    }

    public ActionStats getStats(E category) {
        return this.statsPerCat.get(category);
    }

    public Map<E, ActionStats> getCategoryStats() {
        return Collections.unmodifiableMap(this.statsPerCat);
    }

    public void setRunningCount(int runningCount) {
        this.runningCount = runningCount;
    }

    public void setCategoryStats(E category, long completed, long totalDuration) {
        ActionStats actionStats = new ActionStats(completed, totalDuration);
        ActionStats prev = this.statsPerCat.put(category, actionStats);
        if (prev != null) {
            this.totalCompletedCount = (int)((long)this.totalCompletedCount - prev.getCompletedCount());
        }
        this.totalCompletedCount = (int)((long)this.totalCompletedCount + completed);
    }

    public String toString() {
        return this.getFullMetrics().toJSONString();
    }

    @Override
    public JSONObject getOwnMetrics() {
        JSONObject res = new JSONObject();
        res.put((Object)"running", (Object)this.runningCount);
        res.put((Object)"totalCompleted", (Object)this.totalCompletedCount);
        return res;
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        HashMap<String, JsonMonitorable> map = new HashMap<String, JsonMonitorable>();
        for (Map.Entry<E, ActionStats> entry : this.statsPerCat.entrySet()) {
            map.put(((Enum)entry.getKey()).toString(), entry.getValue());
        }
        JsonMonitorableWrapper wrapper = new JsonMonitorableWrapper(map);
        HashMap<String, JsonMonitorableWrapper> res = new HashMap<String, JsonMonitorableWrapper>();
        res.put("perCategory", wrapper);
        return res;
    }
}

