/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONObject;

public abstract class EventStatsMap<E> {
    private final Map<E, Long> countsPerCat;

    protected EventStatsMap(Map<E, Long> map) {
        this.countsPerCat = map;
    }

    public Long getCount(E category) {
        return this.countsPerCat.get(category);
    }

    public Map<E, Long> getCategoryStats() {
        return Collections.unmodifiableMap(this.countsPerCat);
    }

    public void setCategoryCounts(E category, long count) {
        this.countsPerCat.put(category, count);
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public JSONObject toJson() {
        JSONObject res = new JSONObject();
        for (Map.Entry<E, Long> entry : this.countsPerCat.entrySet()) {
            res.put((Object)entry.getKey().toString(), (Object)entry.getValue());
        }
        return res;
    }

    public void add(EventStatsMap<E> other) {
        for (Map.Entry<E, Long> entry : other.countsPerCat.entrySet()) {
            Long count = this.countsPerCat.get(entry.getKey());
            if (count == null) {
                count = 0L;
            }
            this.countsPerCat.put(entry.getKey(), count + entry.getValue());
        }
    }
}

