/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.pipecraft.infra.monitoring.collectors.AbstractActionStatsCollector;
import org.pipecraft.infra.monitoring.collectors.ActionStatsMap;

public class NonBlockingActionStatsCollector<E extends Enum<E>>
extends AbstractActionStatsCollector<E> {
    private final AtomicInteger running = new AtomicInteger();
    private final EnumMap<E, StatsPair> categoryStats;

    public NonBlockingActionStatsCollector(Class<E> categoriesEnumClass) {
        super(categoriesEnumClass);
        EnumMap<E, StatsPair> stats = new EnumMap<E, StatsPair>(categoriesEnumClass);
        for (Enum category : (Enum[])categoriesEnumClass.getEnumConstants()) {
            stats.put(category, new StatsPair());
        }
        this.categoryStats = stats;
    }

    @Override
    protected void innerStart() {
        this.running.incrementAndGet();
    }

    @Override
    protected void innerEnd(E category, long duration) {
        this.running.decrementAndGet();
        StatsPair pair = this.categoryStats.get(category);
        pair.count.incrementAndGet();
        pair.totalDurationMicros.addAndGet(duration);
    }

    @Override
    public void startAndEnd(E category) {
        StatsPair pair = this.categoryStats.get(category);
        pair.count.incrementAndGet();
    }

    @Override
    public int getRunning() {
        return this.running.get();
    }

    @Override
    public long getCompletedCount(E category) {
        return this.categoryStats.get(category).count.get();
    }

    @Override
    public long getTotalDurationMicros(E category) {
        return this.categoryStats.get(category).totalDurationMicros.get();
    }

    @Override
    public ActionStatsMap<E> getAll() {
        ActionStatsMap<Enum> stats = new ActionStatsMap<Enum>(this.categoriesEnumClass);
        stats.setRunningCount(this.getRunning());
        for (Map.Entry<E, StatsPair> entry : this.categoryStats.entrySet()) {
            Enum category = (Enum)entry.getKey();
            StatsPair pair = this.categoryStats.get(category);
            stats.setCategoryStats((Enum)entry.getKey(), pair.count.get(), pair.totalDurationMicros.get());
        }
        return stats;
    }

    @Override
    public void clear() {
        this.running.set(0);
        for (StatsPair pair : this.categoryStats.values()) {
            pair.count.set(0L);
            pair.totalDurationMicros.set(0L);
        }
    }

    private static class StatsPair {
        public final AtomicLong count = new AtomicLong();
        public final AtomicLong totalDurationMicros = new AtomicLong();

        private StatsPair() {
        }
    }
}

