/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.collectors;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.collectors.EventStatsMap;
import org.pipecraft.infra.monitoring.collectors.UnboundedEventStatsMap;

public class UnboundedEventsCollector<T>
implements JsonMonitorable {
    private final ConcurrentHashMap<T, AtomicLong> counters = new ConcurrentHashMap();

    public Set<T> getCategories() {
        return Collections.unmodifiableSet(this.counters.keySet());
    }

    public void countEvent(T category, long multiplicity) {
        AtomicLong counter = this.counters.get(category);
        if (counter == null) {
            counter = this.counters.computeIfAbsent(category, k -> new AtomicLong());
        }
        counter.addAndGet(multiplicity);
    }

    public long reset(T category) {
        AtomicLong counter = this.counters.get(category);
        if (counter != null) {
            return counter.getAndSet(0L);
        }
        return 0L;
    }

    public long getCount(T category) {
        AtomicLong counter = this.counters.get(category);
        if (counter == null) {
            return 0L;
        }
        return counter.get();
    }

    public EventStatsMap<T> getAll() {
        UnboundedEventStatsMap stats = new UnboundedEventStatsMap();
        for (Map.Entry<T, AtomicLong> entry : this.counters.entrySet()) {
            T category = entry.getKey();
            AtomicLong counter = this.counters.get(category);
            stats.setCategoryCounts(entry.getKey(), counter.get());
        }
        return stats;
    }

    @Override
    public JSONObject getOwnMetrics() {
        return this.getAll().toJson();
    }

    @Override
    public Map<String, ? extends JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }
}

