/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.quantile;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.pipecraft.infra.monitoring.quantile.ConcurrentQuantileEstimator;
import org.pipecraft.infra.monitoring.quantile.QuantileDigest;

public class MultiQuantileDigest
implements ConcurrentQuantileEstimator {
    private static final double COMPRESSION_INFLATION_DEFAULT = 1.5;
    private static final double COMPRESSION_DEFAULT = 100.0;
    private final List<QuantileDigest> digests;
    private final int digestCount;
    private final double compression;
    private final double compressionInflation;
    private final AtomicLong roundRobinIndex = new AtomicLong();

    public MultiQuantileDigest(int digestCount) {
        this(digestCount, 100.0, 1.5);
    }

    public MultiQuantileDigest(int digestCount, double compression) {
        this(digestCount, compression, 1.5);
    }

    public MultiQuantileDigest(int digestCount, double compression, double compressionInflationMultiplier) {
        Validate.isTrue((digestCount > 0 ? 1 : 0) != 0, (String)"digestCount must be greater than 0", (Object[])new Object[0]);
        Validate.isTrue((compression > 0.0 ? 1 : 0) != 0, (String)"compression must be greater than 0", (Object[])new Object[0]);
        Validate.isTrue((compressionInflationMultiplier > 1.0 ? 1 : 0) != 0, (String)"inflationMultiplier must be greater than 1", (Object[])new Object[0]);
        this.digestCount = digestCount;
        this.compression = compression;
        this.compressionInflation = compressionInflationMultiplier;
        this.digests = new ArrayList<QuantileDigest>(digestCount);
        for (int i = 0; i < digestCount; ++i) {
            this.digests.add(new QuantileDigest(compression * compressionInflationMultiplier));
        }
    }

    public double getCompressionInflation() {
        return this.compressionInflation;
    }

    public double getCompression() {
        return this.compression;
    }

    public QuantileDigest reset() {
        ArrayList<QuantileDigest> finalState = new ArrayList<QuantileDigest>(this.digestCount);
        for (QuantileDigest digest : this.digests) {
            finalState.add(digest.reset());
        }
        QuantileDigest digest = new QuantileDigest(this.compression);
        digest.add(finalState);
        return digest;
    }

    public QuantileDigest summarize() {
        QuantileDigest digest = new QuantileDigest(this.compression);
        digest.add(this.digests);
        return digest;
    }

    @Override
    public double quantile(double q) {
        return this.summarize().quantile(q);
    }

    @Override
    public List<Double> quantile(List<Double> qs) {
        QuantileDigest digest = this.summarize();
        ArrayList<Double> quantiles = new ArrayList<Double>(qs.size());
        for (Double q : qs) {
            quantiles.add(digest.quantile(q));
        }
        return quantiles;
    }

    @Override
    public long size() {
        return this.summarize().size();
    }

    @Override
    public double cdf(double x) {
        return this.summarize().cdf(x);
    }

    @Override
    public List<Double> cdf(List<Double> coords) {
        QuantileDigest digest = this.summarize();
        ArrayList<Double> quantiles = new ArrayList<Double>(coords.size());
        for (Double x : coords) {
            quantiles.add(digest.cdf(x));
        }
        return quantiles;
    }

    @Override
    public boolean tryAdd(double x, int w) {
        int digest_idx = (int)(this.roundRobinIndex.incrementAndGet() % (long)this.digestCount);
        return this.digests.get(digest_idx).tryAdd(x, w);
    }

    @Override
    public void add(double x, int w) {
        int digest_idx = (int)(this.roundRobinIndex.incrementAndGet() % (long)this.digestCount);
        this.digests.get(digest_idx).add(x, w);
    }
}

