/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.quantile;

import com.tdunning.math.stats.MergingDigest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.pipecraft.infra.monitoring.quantile.ConcurrentQuantileEstimator;

public class QuantileDigest
implements ConcurrentQuantileEstimator {
    private MergingDigest digest;
    private final double compression;
    private final ReentrantLock lock = new ReentrantLock();

    public QuantileDigest(double compression) {
        this.digest = new MergingDigest(compression);
        this.compression = compression;
    }

    public static QuantileDigest wrap(MergingDigest digest) {
        QuantileDigest wrapped = new QuantileDigest(digest.compression());
        wrapped.add(Collections.singletonList(new QuantileDigest(digest)));
        return wrapped;
    }

    public static QuantileDigest fromBytes(ByteBuffer buff) {
        return new QuantileDigest(MergingDigest.fromBytes((ByteBuffer)buff));
    }

    public double getCompression() {
        return this.compression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<QuantileDigest> others) {
        if (others.size() == 0) {
            return;
        }
        ArrayList<MergingDigest> copies = new ArrayList<MergingDigest>();
        for (QuantileDigest other : others) {
            if (other.size() <= 0L) continue;
            copies.add(other.getDigestCopy());
        }
        this.lock.lock();
        try {
            this.digest.add(copies);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(QuantileDigest other) {
        this.add(Collections.singletonList(other));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer asReadOnlyBuffer() {
        this.lock.lock();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.digest.byteSize());
            this.digest.asBytes(buffer);
            ByteBuffer readOnly = buffer.asReadOnlyBuffer();
            readOnly.rewind();
            ByteBuffer byteBuffer = readOnly;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public QuantileDigest reset() {
        this.lock.lock();
        try {
            QuantileDigest current = new QuantileDigest(this.getDigestCopy());
            this.digest = new MergingDigest(this.compression);
            QuantileDigest quantileDigest = current;
            return quantileDigest;
        }
        finally {
            this.lock.unlock();
        }
    }

    public double compression() {
        return this.compression;
    }

    public int byteSize() {
        this.lock.lock();
        try {
            int n = this.digest.byteSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long size() {
        this.lock.lock();
        try {
            long l = this.digest.size();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double cdf(double x) {
        this.lock.lock();
        try {
            double d = this.digest.cdf(x);
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Double> cdf(List<Double> coords) {
        this.lock.lock();
        try {
            ArrayList<Double> cdfs = new ArrayList<Double>(coords.size());
            for (Double x : coords) {
                cdfs.add(this.digest.cdf(x.doubleValue()));
            }
            ArrayList<Double> arrayList = cdfs;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double quantile(double q) {
        this.lock.lock();
        try {
            double d = this.digest.quantile(q);
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Double> quantile(List<Double> qs) {
        this.lock.lock();
        try {
            ArrayList<Double> quantiles = new ArrayList<Double>(qs.size());
            for (Double x : qs) {
                quantiles.add(this.digest.quantile(x.doubleValue()));
            }
            ArrayList<Double> arrayList = quantiles;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdd(double x, int w) {
        boolean locked = this.lock.tryLock();
        if (locked) {
            try {
                this.digest.add(x, w);
            }
            finally {
                this.lock.unlock();
            }
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(double x, int w) {
        this.lock.lock();
        try {
            this.digest.add(x, w);
        }
        finally {
            this.lock.unlock();
        }
    }

    private QuantileDigest(MergingDigest digest) {
        this.digest = digest;
        this.compression = digest.compression();
    }

    private MergingDigest getDigestCopy() {
        this.lock.lock();
        try {
            ByteBuffer buffer = this.asReadOnlyBuffer();
            MergingDigest mergingDigest = MergingDigest.fromBytes((ByteBuffer)buffer);
            return mergingDigest;
        }
        finally {
            this.lock.unlock();
        }
    }
}

