/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.sampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.sampling.SampleTextualizer;
import org.pipecraft.infra.monitoring.sampling.Sampler;
import org.pipecraft.infra.monitoring.sampling.SimpleSampleTextualizer;

public class BlockingSampler<T>
implements Sampler<T> {
    private final T[] arr;
    private int pos;
    private final SampleTextualizer<T> textualizer;
    private final Object lock = new Object();

    public BlockingSampler(int size, SampleTextualizer<T> textualizer) {
        this.arr = new Object[size];
        this.textualizer = textualizer;
    }

    public BlockingSampler(int size) {
        this(size, new SimpleSampleTextualizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean newValue(T value) {
        Object object = this.lock;
        synchronized (object) {
            int newPos = (this.pos + 1) % this.arr.length;
            this.arr[newPos] = value;
            ++this.pos;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> getSnapshot() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<T> res = new ArrayList<T>(this.arr.length);
            for (int i = 0; i < this.arr.length; ++i) {
                int ind = (this.pos - i + this.arr.length) % this.arr.length;
                T value = this.arr[ind];
                res.add(value);
            }
            return res;
        }
    }

    @Override
    public JSONObject getOwnMetrics() {
        Collection<T> snapshot = this.getSnapshot();
        JSONObject res = new JSONObject();
        JSONArray jsonArr = new JSONArray();
        for (T value : snapshot) {
            jsonArr.add((Object)this.textualizer.toText(value));
        }
        res.put((Object)"items", (Object)jsonArr);
        return res;
    }

    public Map<String, JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public int size() {
        return this.arr.length;
    }
}

