/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.sampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.pipecraft.infra.monitoring.JsonMonitorable;
import org.pipecraft.infra.monitoring.sampling.SampleTextualizer;
import org.pipecraft.infra.monitoring.sampling.Sampler;
import org.pipecraft.infra.monitoring.sampling.SimpleSampleTextualizer;

public class InaccurateSampler<T>
implements Sampler<T> {
    private final AtomicReferenceArray<T> arr;
    private final AtomicInteger pos = new AtomicInteger();
    private final SampleTextualizer<T> textualizer;

    public InaccurateSampler(int size, SampleTextualizer<T> textualizer) {
        this.arr = new AtomicReferenceArray(size);
        this.textualizer = textualizer;
    }

    public InaccurateSampler(int size) {
        this(size, new SimpleSampleTextualizer());
    }

    @Override
    public boolean newValue(T value) {
        int reservedPos;
        int currPos = this.pos.get();
        if (this.pos.compareAndSet(currPos, reservedPos = (currPos + 1) % this.arr.length())) {
            this.arr.set(reservedPos, value);
            return true;
        }
        return false;
    }

    @Override
    public Collection<T> getSnapshot() {
        ArrayList<T> res = new ArrayList<T>(this.arr.length());
        for (int i = 0; i < this.arr.length(); ++i) {
            T value = this.arr.get(i);
            res.add(value);
        }
        return res;
    }

    @Override
    public JSONObject getOwnMetrics() {
        JSONObject res = new JSONObject();
        JSONArray jsonArr = new JSONArray();
        for (int i = 0; i < this.arr.length(); ++i) {
            T value = this.arr.get(i);
            jsonArr.add((Object)this.textualizer.toText(value));
        }
        res.put((Object)"items", (Object)jsonArr);
        return res;
    }

    public Map<String, JsonMonitorable> getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public int size() {
        return this.arr.length();
    }
}

