/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.monitoring.sliding;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.pipecraft.infra.monitoring.sliding.SlidingWindow;
import org.pipecraft.infra.monitoring.sliding.SlotRecord;

public class AverageSlidingWindow
extends SlidingWindow<Long, SlotRecord, Float> {
    public AverageSlidingWindow(int slotsCount, int slotTime, TimeUnit slotTimeUnit, ScheduledExecutorService ex) {
        super(slotsCount, slotTime, slotTimeUnit, ex);
    }

    @Override
    protected void newEvent(Long value, SlotRecord rec) {
        rec.inc(value);
    }

    @Override
    protected SlotRecord newRecord() {
        return new SlotRecord();
    }

    protected SlotRecord[] newRecordArray(int size) {
        return new SlotRecord[size];
    }

    @Override
    protected void clearRecord(SlotRecord record) {
        record.clear();
    }

    protected Float query(SlotRecord[] records) {
        long total = 0L;
        long totalCount = 0L;
        for (SlotRecord rec : records) {
            total += rec.getTotal();
            totalCount += (long)rec.getTotalCount();
        }
        if (totalCount == 0L) {
            return null;
        }
        return Float.valueOf((float)total / (float)totalCount);
    }

    public long count() {
        long totalCount = 0L;
        for (int i = 0; i < this.getSlotsCount(); ++i) {
            SlotRecord rec = (SlotRecord)this.getRecord(i);
            totalCount += (long)rec.getTotalCount();
        }
        return totalCount;
    }
}

