/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.pipecraft.infra.concurrent.ParallelTaskProcessor;
import org.pipecraft.infra.io.Retrier;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.storage.IllegalJsonException;
import org.pipecraft.infra.storage.PathUtils;

public abstract class Bucket<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DONE_FILE_NAME = "_DONE";
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final Long UNLIMITED_CONTENT_LENGTH = null;
    private static final Function<String, String> DEFAULT_FILE_NAME_RESOLVER = PathUtils::getLastPathPart;
    protected static final int DEFAULT_RETRY_INITIAL_SLEEP_SEC = 1;
    protected static final int DEFAULT_RETRY_MAX_ATTEMPTS = 4;
    protected static final double DEFAULT_RETRY_WAIT_TIME_FACTOR = 2.0;
    protected static final Retrier DEFAULT_RETRIER = new Retrier(1000, 2.0, 4);
    private final String bucketName;

    public Bucket(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public abstract void put(String var1, InputStream var2, long var3, String var5, boolean var6, boolean var7) throws IOException;

    public void put(String key, InputStream input, long length, String contentType, boolean isPublic) throws IOException {
        this.put(key, input, length, contentType, isPublic, true);
    }

    public void putFile(String key, File input, boolean isPublic) throws IOException {
        this.put(key, new FileInputStream(input), input.length(), null, isPublic);
    }

    public boolean putLockFile(String key) throws IOException {
        boolean bl;
        ByteArrayInputStream emptyStream = new ByteArrayInputStream(EMPTY_BUFFER);
        try {
            this.put(key, emptyStream, 0L, "text/plain", false, false);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)emptyStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileAlreadyExistsException e) {
                return false;
            }
        }
        ((InputStream)emptyStream).close();
        return bl;
    }

    public void putEmptyFile(String key) throws IOException {
        try (ByteArrayInputStream emptyStream = new ByteArrayInputStream(EMPTY_BUFFER);){
            this.put(key, emptyStream, 0L, "text/plain", false, true);
        }
    }

    public String putDoneFile(String folderPath) throws IOException {
        String key = PathUtils.buildPath(folderPath, DONE_FILE_NAME);
        this.putEmptyFile(key);
        return key;
    }

    public OutputStream getOutputStream(String key) throws IOException {
        return this.getOutputStream(key, 0);
    }

    public abstract OutputStream getOutputStream(String var1, int var2) throws IOException;

    public void putPublic(String key, File input) throws IOException {
        this.putFile(key, input, true);
    }

    public void putPublic(String key, InputStream input, long length, String contentType) throws IOException {
        this.put(key, input, length, contentType, true);
    }

    public String putUniquePublic(String folderPath, File input) throws IOException {
        String key = Bucket.generateUniqueKey(folderPath, "");
        this.putPublic(key, input);
        return key;
    }

    public String putUniquePublic(String folderPath, InputStream input, long length, String contentType) throws IOException {
        return this.putUniquePublic(folderPath, input, null, length, contentType);
    }

    public String putUniquePublic(String folderPath, InputStream input, String extension, long length, String contentType) throws IOException {
        if (extension == null) {
            extension = "";
        }
        String key = Bucket.generateUniqueKey(folderPath, extension);
        this.putPublic(key, input, length, contentType);
        return key;
    }

    public void putPrivate(String key, File input) throws IOException {
        this.putFile(key, input, false);
    }

    public void putPrivate(String key, InputStream input, long length, String contentType) throws IOException {
        this.put(key, input, length, contentType, false);
    }

    public String putUniquePrivate(String folderPath, File input) throws IOException {
        String key = Bucket.generateUniqueKey(folderPath, "");
        this.putPrivate(key, input);
        return key;
    }

    public String putUniquePrivate(String folderPath, InputStream input, long length, String contentType) throws IOException {
        return this.putUniquePrivate(folderPath, input, null, length, contentType);
    }

    public String putUniquePrivate(String folderPath, InputStream input, String extension, long length, String contentType) throws IOException {
        if (extension == null) {
            extension = "";
        }
        String key = Bucket.generateUniqueKey(folderPath, extension);
        this.putPrivate(key, input, length, contentType);
        return key;
    }

    public void putFileInterruptibly(String key, File input, boolean isPublic, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.put(key, new FileInputStream(input), input.length(), null, isPublic), Collections.singleton(FileNotFoundException.class), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void putFileInterruptibly(String key, File input, boolean isPublic) throws IOException, InterruptedException {
        this.putFileInterruptibly(key, input, isPublic, 4, 1, 2.0);
    }

    public void putAllInterruptibly(String targetFolder, File inputFolder, int parallelism, boolean isPublic, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        String finalPath = this.normalizeFolderPath(targetFolder);
        if (!inputFolder.isDirectory()) {
            throw new FileNotFoundException("The folder " + inputFolder.getAbsolutePath() + " does not exist or isn't a folder");
        }
        List<File> files = Arrays.asList(inputFolder.listFiles(File::isFile));
        ParallelTaskProcessor.runFailable(files, parallelism, f -> this.putFileInterruptibly(finalPath + f.getName(), (File)f, isPublic, maxRetries, initialRetrySleepSec, waitTimeFactor));
    }

    public void putAllInterruptibly(String targetFolder, File inputFolder, int parallelism, boolean isPublic) throws IOException, InterruptedException {
        this.putAllInterruptibly(targetFolder, inputFolder, parallelism, isPublic, 4, 1, 2.0);
    }

    public void putAllRecursiveInterruptibly(String targetFolder, File inputFolder, int parallelism, boolean isPublic, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        String finalPath = this.normalizeFolderPath(targetFolder);
        if (!inputFolder.isDirectory()) {
            throw new FileNotFoundException("The folder " + inputFolder.getAbsolutePath() + " does not exist or isn't a folder");
        }
        Path basePath = inputFolder.toPath();
        List files = Files.walk(basePath, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).map(p -> basePath.relativize((Path)p)).collect(Collectors.toList());
        ParallelTaskProcessor.runFailable(files, parallelism, f -> this.putFileInterruptibly(finalPath + f.toFile().getPath(), basePath.resolve((Path)f).toFile(), isPublic, maxRetries, initialRetrySleepSec, waitTimeFactor));
    }

    public void putAllRecursiveInterruptibly(String targetFolder, File inputFolder, int parallelism, boolean isPublic) throws IOException, InterruptedException {
        this.putAllRecursiveInterruptibly(targetFolder, inputFolder, parallelism, isPublic, 4, 1, 2.0);
    }

    public abstract void get(T var1, File var2) throws IOException;

    public void get(String key, File output) throws IOException {
        T meta = this.getObjectMetadata(key);
        this.get(meta, output);
    }

    public void getSliced(String key, File output, int chunkSize) throws IOException, InterruptedException {
        this.get(key, output);
    }

    public void getSliced(String key, File output) throws IOException {
        try {
            this.getSliced(key, output, 0);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public abstract SizedInputStream getAsStream(T var1, int var2) throws IOException;

    public SizedInputStream getAsStream(String key) throws IOException {
        return this.getAsStream(key, 0);
    }

    public SizedInputStream getAsStream(T meta) throws IOException {
        return this.getAsStream(meta, 0);
    }

    public SizedInputStream getAsStream(String key, int chunkSize) throws IOException {
        return this.getAsStream(this.getObjectMetadata(key), chunkSize);
    }

    public <C> C getFromJson(String key, Class<C> clazz) throws IOException, IllegalJsonException {
        SizedInputStream is = this.getAsStream(key);
        try {
            return (C)OBJECT_MAPPER.readValue((InputStream)is, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalJsonException("Illegal json in '" + this.getBucketName() + "/" + key + "'", e);
        }
    }

    public void getInterruptibly(String key, File output, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        T meta = this.getObjectMetadata(key);
        this.getInterruptibly(meta, output, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public void getInterruptibly(T meta, File output, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.get(meta, output), Collections.singleton(FileNotFoundException.class), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void getInterruptibly(String key, File output) throws IOException, InterruptedException {
        T meta = this.getObjectMetadata(key);
        this.getInterruptibly(meta, output);
    }

    public void getInterruptibly(T meta, File output) throws IOException, InterruptedException {
        this.getInterruptibly(meta, output, 4, 1, 2.0);
    }

    public Set<File> getAllRegularFilesInterruptibly(String folderPath, File targetFolder, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesInterruptibly(folderPath, (T b) -> true, targetFolder, parallelism, 4, 1, 2.0);
    }

    public Set<File> getAllRegularFilesInterruptibly(String folderPath, Predicate<T> predicate, File targetFolder, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        folderPath = this.normalizeFolderPath(folderPath);
        Iterator<T> it = this.listObjects(folderPath, predicate);
        List remoteFileObjects = Streams.stream(it).filter(this::isFile).collect(Collectors.toList());
        return this.getAllRegularFilesByMetaInterruptibly(remoteFileObjects, targetFolder, DEFAULT_FILE_NAME_RESOLVER, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public Set<File> getAllRegularFilesInterruptibly(String folderPath, Predicate<T> predicate, File targetFolder, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesInterruptibly(folderPath, predicate, targetFolder, parallelism, 4, 1, 2.0);
    }

    public Set<File> getAllRegularFiles(Collection<String> folderPaths, File targetFolder, Function<String, String> fileNameResolver, int parallelism) throws IOException {
        try {
            return this.getAllRegularFilesInterruptibly(folderPaths, targetFolder, fileNameResolver, parallelism, 4, 1, 2.0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public Set<File> getAllRegularFilesInterruptibly(Collection<String> cloudFilePaths, File targetFolder, Function<String, String> fileNameResolver, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Map<String, T> metaObjs = this.getObjectMetadata(cloudFilePaths, maxRetries, initialRetrySleepSec, waitTimeFactor);
        this.validateAllPathsExist(metaObjs);
        return this.getAllRegularFilesByMetaInterruptibly(metaObjs.values(), targetFolder, fileNameResolver, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public Set<File> getAllRegularFilesInterruptibly(Collection<String> cloudFilePaths, File targetFolder, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        return this.getAllRegularFilesInterruptibly(cloudFilePaths, targetFolder, DEFAULT_FILE_NAME_RESOLVER, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public Set<File> getAllRegularFilesInterruptibly(Collection<String> cloudFilePaths, File targetFolder, Function<String, String> fileNameResolver, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesInterruptibly(cloudFilePaths, targetFolder, fileNameResolver, parallelism, 4, 1, 2.0);
    }

    public Set<File> getAllRegularFilesInterruptibly(Collection<String> filePaths, File targetFolder, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesInterruptibly(filePaths, targetFolder, DEFAULT_FILE_NAME_RESOLVER, parallelism);
    }

    public Set<File> getAllRegularFilesByMetaInterruptibly(Collection<T> metaObjects, File targetFolder, Function<String, String> fileNameResolver, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        targetFolder.mkdirs();
        if (!targetFolder.isDirectory()) {
            throw new IOException("Not a folder: " + targetFolder);
        }
        Set<File> res = Collections.synchronizedSet(new HashSet());
        ParallelTaskProcessor.runFailable(metaObjects, parallelism, f -> {
            File localFile = new File(targetFolder, (String)fileNameResolver.apply(this.getPath(f)));
            this.getInterruptibly(f, localFile, maxRetries, initialRetrySleepSec, waitTimeFactor);
            res.add(localFile);
        });
        return res;
    }

    public Set<File> getAllRegularFilesByMetaInterruptibly(Collection<T> metaObjects, File targetFolder, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        return this.getAllRegularFilesByMetaInterruptibly(metaObjects, targetFolder, DEFAULT_FILE_NAME_RESOLVER, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public Set<File> getAllRegularFilesByMetaInterruptibly(Collection<T> metaObjects, File targetFolder, Function<String, String> fileNameResolver, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesByMetaInterruptibly(metaObjects, targetFolder, fileNameResolver, parallelism, 4, 1, 2.0);
    }

    public Set<File> getAllRegularFilesByMetaInterruptibly(Collection<T> metaObjects, File targetFolder, int parallelism) throws IOException, InterruptedException {
        return this.getAllRegularFilesByMetaInterruptibly(metaObjects, targetFolder, DEFAULT_FILE_NAME_RESOLVER, parallelism);
    }

    public abstract void copyToAnotherBucket(String var1, String var2, String var3) throws IOException;

    public void copy(String fromKey, String toKey) throws IOException {
        this.copyToAnotherBucket(fromKey, this.getBucketName(), toKey);
    }

    public void copyInterruptibly(String fromKey, String toKey, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.copy(fromKey, toKey), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void copyInterruptibly(String fromKey, String toKey) throws IOException, InterruptedException {
        this.copyInterruptibly(fromKey, toKey, 4, 1, 2.0);
    }

    public void copyToAnotherBucketInterruptibly(String fromKey, String toBucket, String toKey, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.copyToAnotherBucket(fromKey, toBucket, toKey), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void copyToAnotherBucketInterruptibly(String fromKey, String toBucket, String toKey) throws IOException, InterruptedException {
        this.copyToAnotherBucketInterruptibly(fromKey, toBucket, toKey, 4, 1, 2.0);
    }

    public void copyFolderRecursiveInterruptibly(String srcPath, String dstPath, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        String srcPathNorm = this.normalizeFolderPath(srcPath);
        String dstPathNorm = this.normalizeFolderPath(dstPath);
        Iterator<T> it = this.listFilesRecursive(srcPathNorm);
        List srcToDstPaths = Streams.stream(it).map(this::getPath).map(srcFilePath -> Pair.of((Object)srcFilePath, (Object)srcFilePath.replace(srcPathNorm, dstPathNorm))).collect(Collectors.toList());
        ParallelTaskProcessor.runFailable(srcToDstPaths, parallelism, f -> this.copyInterruptibly((String)f.getLeft(), (String)f.getRight(), maxRetries, initialRetrySleepSec, waitTimeFactor));
    }

    public void copyFolderRecursiveInterruptibly(String srcPath, String dstPath, int parallelism) throws IOException, InterruptedException {
        this.copyFolderRecursiveInterruptibly(srcPath, dstPath, parallelism, 4, 1, 2.0);
    }

    public abstract void delete(T var1) throws IOException;

    public void delete(String key) throws IOException {
        try {
            T meta = this.getObjectMetadata(key);
            this.delete(meta);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void deleteInterruptibly(String key, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.delete(key), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void deleteInterruptibly(T objectMeta, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Retrier.run(() -> this.delete(objectMeta), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
    }

    public void deleteInterruptibly(String key) throws IOException, InterruptedException {
        this.deleteInterruptibly(key, 4, 1, 2.0);
    }

    public void deleteInterruptibly(T objectMeta) throws IOException, InterruptedException {
        this.deleteInterruptibly(objectMeta, 4, 1, 2.0);
    }

    public void deleteFolderRegularFiles(String path) throws IOException {
        path = this.normalizeFolderPath(path);
        Iterator<T> it = this.listFiles(path);
        try {
            this.deleteAllByMetaInterruptibly(it, Runtime.getRuntime().availableProcessors());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while deleting remote folder files from '" + path + "'");
        }
    }

    public void deleteFolderRecursiveInterruptibly(String path, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Iterator<T> it = this.listFilesRecursive(this.normalizeFolderPath(path));
        this.deleteAllByMetaInterruptibly(it, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public void deleteFolderRecursiveInterruptibly(String path, int parallelism) throws IOException, InterruptedException {
        this.deleteFolderRecursiveInterruptibly(path, parallelism, 4, 1, 2.0);
    }

    public void deleteAllByMetaInterruptibly(Iterator<T> fileRefsIt, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        ArrayList<T> pathsChunk = new ArrayList<T>();
        while (fileRefsIt.hasNext()) {
            pathsChunk.clear();
            while (fileRefsIt.hasNext() && pathsChunk.size() < 10000) {
                pathsChunk.add(fileRefsIt.next());
            }
            this.deleteAllByMetaInterruptibly(pathsChunk, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
        }
    }

    public void deleteAllByMetaInterruptibly(Iterator<T> fileRefsIt, int parallelism) throws IOException, InterruptedException {
        this.deleteAllByMetaInterruptibly(fileRefsIt, parallelism, 4, 1, 2.0);
    }

    public void deleteAllByMetaInterruptibly(Collection<T> fileRefs, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        ParallelTaskProcessor.runFailable(fileRefs, parallelism, m -> this.deleteInterruptibly(m, maxRetries, initialRetrySleepSec, waitTimeFactor));
    }

    public void deleteAllByMetaInterruptibly(Collection<T> fileRefs, int parallelism) throws IOException, InterruptedException {
        this.deleteAllByMetaInterruptibly(fileRefs, parallelism, 4, 1, 2.0);
    }

    public void deleteAllInterruptibly(Iterator<String> filePathsIt, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        ArrayList<String> pathsChunk = new ArrayList<String>();
        while (filePathsIt.hasNext()) {
            pathsChunk.clear();
            while (filePathsIt.hasNext() && pathsChunk.size() < 10000) {
                pathsChunk.add(filePathsIt.next());
            }
            Map<String, T> metaObjs = this.getObjectMetadata(pathsChunk, maxRetries, initialRetrySleepSec, waitTimeFactor);
            List existingObjects = metaObjs.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.deleteAllByMetaInterruptibly(existingObjects, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
        }
    }

    public void deleteAllInterruptibly(Iterator<String> filePathsIt, int parallelism) throws IOException, InterruptedException {
        this.deleteAllInterruptibly(filePathsIt, parallelism, 4, 1, 2.0);
    }

    public void deleteAllInterruptibly(Collection<String> filePaths, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        Map<String, T> metaObjs = this.getObjectMetadata(filePaths, maxRetries, initialRetrySleepSec, waitTimeFactor);
        List existingObjects = metaObjs.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.deleteAllByMetaInterruptibly(existingObjects, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public void deleteAllInterruptibly(Collection<String> filePaths, int parallelism) throws IOException, InterruptedException {
        this.deleteAllInterruptibly(filePaths, parallelism, 4, 1, 2.0);
    }

    public void moveInterruptibly(String fromKey, String toKey, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        this.copyToAnotherBucketInterruptibly(fromKey, this.getBucketName(), toKey, maxRetries, initialRetrySleepSec, waitTimeFactor);
        this.deleteInterruptibly(fromKey, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public void moveInterruptibly(String fromKey, String toKey) throws IOException, InterruptedException {
        this.moveInterruptibly(fromKey, toKey, 4, 1, 2.0);
    }

    public void moveFolderRecursive(String srcPath, String dstPath, int parallelism, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        this.copyFolderRecursiveInterruptibly(srcPath, dstPath, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
        this.deleteFolderRecursiveInterruptibly(srcPath, parallelism, maxRetries, initialRetrySleepSec, waitTimeFactor);
    }

    public void moveFolderRecursive(String srcPath, String dstPath, int parallelism) throws IOException, InterruptedException {
        this.moveFolderRecursive(srcPath, dstPath, parallelism, 4, 1, 2.0);
    }

    public String normalizeFolderPath(String path) {
        if (!this.isFolderPath((String)path)) {
            path = (String)path + "/";
        }
        return path;
    }

    public abstract boolean exists(String var1) throws IOException;

    public abstract Iterator<T> listObjects(String var1, boolean var2) throws IOException;

    public Iterator<T> listObjects(String folderPath) throws IOException {
        return this.listObjects(folderPath, false);
    }

    public Iterator<T> listObjects(String folderPath, Predicate<T> condition) throws IOException {
        Iterator<T> allObjectsIterator = this.listObjects(folderPath, false);
        return Iterators.filter(allObjectsIterator, condition::test);
    }

    public Iterator<T> listFilesRecursive(String folderPath) throws IOException {
        Iterator<T> it = this.listObjects(folderPath, true);
        return Iterators.filter(it, this::isFile);
    }

    public Iterator<T> listFilesRecursive(String folderPath, Pattern pattern) throws IOException {
        Iterator<T> blobIterator = this.listFilesRecursive(folderPath);
        Predicate<Object> namePatternPredicate = blob -> pattern.matcher(this.getPath(blob)).matches();
        return Iterators.filter(blobIterator, namePatternPredicate::test);
    }

    public Iterator<T> listFilesRecursive(String folderPath, String fileRegex) throws IOException {
        return this.listFilesRecursive(folderPath, Pattern.compile(fileRegex));
    }

    public Iterator<T> listFiles(String folderPath) throws IOException {
        return this.listObjects(folderPath, this::isFile);
    }

    public Iterator<T> listFiles(String folderPath, Pattern filePattern) throws IOException {
        Predicate<Object> matchingFilesPredicate = ((Predicate<Object>)this::isFile).and(blob -> filePattern.matcher(PathUtils.getLastPathPart(this.getPath(blob))).matches());
        return this.listObjects(folderPath, matchingFilesPredicate);
    }

    public Iterator<T> listFolders(String folderPath) throws IOException {
        return this.listObjects(folderPath, (Predicate<T>)Predicates.not(this::isFile));
    }

    public Iterator<T> listFiles(String folderPath, String fileRegex) throws IOException {
        return this.listFiles(folderPath, Pattern.compile(fileRegex));
    }

    public T getLastFile(String path, Pattern pattern) throws IOException {
        Optional<Object> max = Streams.stream(this.listFilesRecursive(path, pattern)).max(Comparator.comparing(this::getPath));
        return max.orElse(null);
    }

    public abstract T getObjectMetadata(String var1) throws IOException;

    public Map<String, T> getObjectMetadata(Collection<String> filePaths) throws IOException, InterruptedException {
        Map res = Collections.synchronizedMap(new HashMap());
        ParallelTaskProcessor.runFailable(filePaths, Runtime.getRuntime().availableProcessors(), path -> {
            try {
                T meta = this.getObjectMetadata((String)path);
                res.put(path, meta);
            }
            catch (FileNotFoundException e) {
                res.put(path, null);
            }
        });
        return res;
    }

    public Map<String, T> getObjectMetadata(Collection<String> filePaths, int maxRetries, int initialRetrySleepSec, double waitTimeFactor) throws IOException, InterruptedException {
        MutableObject metaObjs = new MutableObject();
        Retrier.run(() -> metaObjs.setValue(this.getObjectMetadata(filePaths)), initialRetrySleepSec * 1000, waitTimeFactor, maxRetries + 1);
        return (Map)metaObjs.getValue();
    }

    public abstract String getPath(T var1);

    public abstract long getLength(T var1);

    public abstract Long getLastUpdated(T var1);

    public boolean isFile(T objMetadata) {
        return !this.isFolderPath(this.getPath(objMetadata));
    }

    public URL generateSignedUrl(String key, String contentType, int expirationSeconds) {
        return this.generateSignedUrl(key, contentType, expirationSeconds, false);
    }

    public abstract URL generateSignedUrl(String var1, String var2, int var3, boolean var4);

    public abstract URL generateReadOnlyUrl(String var1, int var2);

    public URL generateResumableSignedUrlForUpload(String key, String contentType, int expirationSeconds) throws IOException {
        return this.generateResumableSignedUrlForUpload(key, contentType, expirationSeconds, UNLIMITED_CONTENT_LENGTH, false);
    }

    public abstract URL generateResumableSignedUrlForUpload(String var1, String var2, int var3, Long var4, boolean var5) throws IOException;

    public abstract T compose(List<String> var1, String var2, boolean var3) throws IOException;

    protected void validateNotFolderPath(String path) throws IOException {
        if (this.isFolderPath(path)) {
            throw new IOException("Illegal path: '" + path + "'. Expected a file path.");
        }
    }

    public boolean isFolderPath(String path) {
        return path.endsWith("/");
    }

    public boolean isFilePath(String path) {
        return !this.isFolderPath(path);
    }

    private static String generateUniqueKey(String path, String fileExtension) {
        return PathUtils.buildPath(path, Long.toHexString(ThreadLocalRandom.current().nextLong()) + fileExtension);
    }

    private void validateAllPathsExist(Map<String, T> pathsToMeta) throws FileNotFoundException {
        Optional<String> nonExistingPath = pathsToMeta.entrySet().stream().filter(x -> x.getValue() == null).map(x -> (String)x.getKey()).findFirst();
        if (nonExistingPath.isPresent()) {
            throw new FileNotFoundException("File doesn't exist: " + nonExistingPath.get());
        }
    }
}

