/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage.local;

import java.io.File;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.infra.storage.local.LocalDiskBucket;

public class LocalDiskStorage
implements Storage<LocalDiskBucket, File> {
    private final File baseStorageFolder;

    public LocalDiskStorage(File baseStorageFolder) {
        this.baseStorageFolder = baseStorageFolder;
    }

    @Override
    public LocalDiskBucket getBucket(String bucketName) {
        return new LocalDiskBucket(this.baseStorageFolder, bucketName);
    }

    @Override
    public String getProtocol() {
        return "file";
    }

    public LocalDiskBucket getOrCreateBucket(String bucketName) {
        File bucketFolder = new File(this.baseStorageFolder, bucketName);
        bucketFolder.mkdirs();
        if (!bucketFolder.isDirectory()) {
            throw new IllegalArgumentException("The bucket folder ('" + bucketFolder + "') can't be created or exists and isn't a folder");
        }
        return new LocalDiskBucket(this.baseStorageFolder, bucketName);
    }
}

