/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.pipecraft.pipes.BasePipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;

public abstract class AsyncPipe<T>
implements BasePipe {
    private volatile AsyncPipeListener<? super T> listener;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.WORKING);

    public void setListener(AsyncPipeListener<? super T> listener) {
        this.listener = listener;
    }

    protected void notifyNext(T item) throws InterruptedException {
        try {
            this.listener.next(item);
        }
        catch (PipeException e) {
            this.notifyError(e);
        }
    }

    protected void notifyDone() throws InterruptedException {
        if (this.status.compareAndSet(Status.WORKING, Status.DONE)) {
            this.listener.done();
        }
    }

    protected void notifyError(PipeException e) throws InterruptedException {
        if (this.status.compareAndSet(Status.WORKING, Status.ERROR)) {
            this.listener.error(e);
        }
    }

    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public void close() throws IOException {
        this.status.set(Status.CLOSED);
    }

    public static enum Status {
        WORKING,
        CLOSED,
        DONE,
        ERROR;

    }
}

