/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import org.pipecraft.infra.concurrent.FailableConsumer;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;

public class AsyncCallbackPipe<T>
extends AsyncPipe<T> {
    private final AsyncPipe<T> inputPipe;
    private final FailableConsumer<? super T, ? extends PipeException> callback;

    public AsyncCallbackPipe(AsyncPipe<T> inputPipe, FailableConsumer<? super T, ? extends PipeException> itemCallback) {
        this.inputPipe = inputPipe;
        this.callback = itemCallback;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.inputPipe.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) throws PipeException, InterruptedException {
                AsyncCallbackPipe.this.callback.accept(item);
                AsyncCallbackPipe.this.notifyNext(item);
            }

            @Override
            public void done() throws InterruptedException {
                AsyncCallbackPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncCallbackPipe.this.notifyError(e);
            }
        });
        this.inputPipe.start();
    }

    @Override
    public float getProgress() {
        return this.inputPipe.getProgress();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputPipe.close();
    }
}

