/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;

public abstract class AsyncCompoundPipe<T>
extends AsyncPipe<T> {
    private AsyncPipe<T> innerPipe;

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            this.innerPipe = this.createPipeline();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
        this.innerPipe.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) throws InterruptedException {
                AsyncCompoundPipe.this.notifyNext(item);
            }

            @Override
            public void done() throws InterruptedException {
                AsyncCompoundPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncCompoundPipe.this.notifyError(e);
            }
        });
        this.innerPipe.start();
    }

    protected abstract AsyncPipe<T> createPipeline() throws IOException;

    @Override
    public void close() throws IOException {
        super.close();
        if (this.innerPipe != null) {
            this.innerPipe.close();
        }
    }

    @Override
    public float getProgress() {
        return this.innerPipe.getProgress();
    }
}

