/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import java.util.function.Predicate;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;

public class AsyncFilterPipe<T>
extends AsyncPipe<T> {
    private final AsyncPipe<T> input;
    private final Predicate<? super T> predicate;

    public AsyncFilterPipe(AsyncPipe<T> input, Predicate<? super T> predicate) {
        this.input = input;
        this.predicate = predicate;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) throws PipeException, InterruptedException {
                if (AsyncFilterPipe.this.predicate.test(item)) {
                    AsyncFilterPipe.this.notifyNext(item);
                }
            }

            @Override
            public void done() throws InterruptedException {
                AsyncFilterPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncFilterPipe.this.notifyError(e);
            }
        });
        this.input.start();
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

