/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.PipeFactory;

public class AsyncFlexibleMapPipe<S, T>
extends AsyncPipe<T> {
    private final AsyncPipe<S> input;
    private final PipeFactory<S, ? extends T> factory;

    public AsyncFlexibleMapPipe(AsyncPipe<S> input, PipeFactory<S, ? extends T> factory) {
        this.input = input;
        this.factory = factory;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.setListener(new AsyncPipeListener<S>(){

            @Override
            public void next(S item) throws PipeException, InterruptedException {
                try {
                    Object next;
                    Pipe p = AsyncFlexibleMapPipe.this.factory.get(item);
                    p.start();
                    while ((next = p.next()) != null) {
                        AsyncFlexibleMapPipe.this.notifyNext(next);
                    }
                }
                catch (IOException e) {
                    throw new IOPipeException(e);
                }
            }

            @Override
            public void done() throws InterruptedException {
                AsyncFlexibleMapPipe.this.notifyDone();
            }

            @Override
            public void error(PipeException e) throws InterruptedException {
                AsyncFlexibleMapPipe.this.notifyError(e);
            }
        });
        this.input.start();
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.input.close();
    }
}

