/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.pipecraft.infra.concurrent.ParallelTaskProcessor;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.PipeSupplier;
import org.pipecraft.pipes.utils.PipeUtils;

public class SyncToAsyncPipe<T>
extends AsyncPipe<T> {
    private final Collection<PipeSupplier<T>> inputPipeSuppliers;
    private final int threadCount;
    private final AtomicInteger donePipesCount;
    private Thread startThread;

    public SyncToAsyncPipe(Collection<PipeSupplier<T>> inputPipeSuppliers, int threadCount) {
        this.inputPipeSuppliers = inputPipeSuppliers;
        this.threadCount = threadCount;
        this.donePipesCount = new AtomicInteger(0);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.startThread = new Thread(() -> {
            boolean error = false;
            try {
                ParallelTaskProcessor.runFailable(this.inputPipeSuppliers, this.threadCount, this::drainPipe);
            }
            catch (PipeException e) {
                error = true;
                this.notifyErrorExitOrInterrupt(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!error) {
                    try {
                        this.notifyDone();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.startThread.start();
    }

    @Override
    public float getProgress() {
        return this.donePipesCount.floatValue() / (float)this.inputPipeSuppliers.size();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.startThread == null) {
            return;
        }
        this.startThread.interrupt();
        try {
            this.startThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted while waiting for threads to terminate");
        }
    }

    public static <T> SyncToAsyncPipe<T> fromPipes(Collection<Pipe<T>> inputs, int threadCount) {
        return new SyncToAsyncPipe<T>(inputs.stream().map(p -> () -> p).collect(Collectors.toList()), threadCount);
    }

    public static <T> SyncToAsyncPipe<T> fromPipe(Pipe<T> input) {
        return new SyncToAsyncPipe(Collections.singleton(() -> input), 1);
    }

    private void notifyErrorExitOrInterrupt(PipeException e) {
        try {
            this.notifyError(e);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Loose catch block
     */
    private void drainPipe(PipeSupplier<T> pipeSupplier) throws PipeException {
        Pipe<T> pipe = null;
        try {
            T next;
            pipe = pipeSupplier.get();
            pipe.start();
            while ((next = pipe.next()) != null && !Thread.currentThread().isInterrupted()) {
                this.notifyNext(next);
            }
            pipe.close();
            this.donePipesCount.incrementAndGet();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            PipeUtils.close(pipe);
        }
        catch (IOException e2) {
            throw new IOPipeException(e2);
            {
                catch (Throwable throwable) {
                    PipeUtils.close(pipe);
                    throw throwable;
                }
            }
        }
        PipeUtils.close(pipe);
    }
}

