/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.inter.distributed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.pipecraft.infra.math.ArithmeticUtils;
import org.pipecraft.infra.net.HostPort;
import org.pipecraft.pipes.serialization.ByteArrayCodec;

public class DistributedShufflerConfig<T> {
    private final List<HostPort> workers;
    private final int port;
    private final Function<T, Integer> shardFunction;
    private final ByteArrayCodec<T> codec;

    private DistributedShufflerConfig(Builder<T> builder) {
        this.workers = builder.workers;
        this.port = builder.port;
        this.shardFunction = builder.shardFunction;
        this.codec = builder.codec;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public List<HostPort> getWorkers() {
        return this.workers;
    }

    public int getPort() {
        return this.port;
    }

    public Function<T, Integer> getShardFunc() {
        return this.shardFunction;
    }

    public ByteArrayCodec<T> getCodec() {
        return this.codec;
    }

    public int getWorkerShardId(HostPort worker) {
        return this.workers.indexOf(worker);
    }

    public static class Builder<T> {
        private List<HostPort> workers;
        private int port;
        private Function<T, Integer> shardFunction;
        private Function<T, Object> shardBy;
        private ByteArrayCodec<T> codec;

        private Builder() {
        }

        public Builder<T> workers(Set<HostPort> workers) {
            this.workers = new ArrayList<HostPort>(workers);
            Collections.sort(this.workers);
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> shardFunc(Function<T, Integer> shardFunction) {
            this.shardFunction = shardFunction;
            this.shardBy = null;
            return this;
        }

        public Builder<T> shardBy(Function<T, Object> shardBy) {
            this.shardBy = shardBy;
            this.shardFunction = null;
            return this;
        }

        public Builder<T> codec(ByteArrayCodec<T> codec) {
            this.codec = codec;
            return this;
        }

        public DistributedShufflerConfig<T> build() {
            if (this.workers == null) {
                throw new IllegalArgumentException("worker set is mandatory");
            }
            if (this.port == 0) {
                throw new IllegalArgumentException("Port is mandatory");
            }
            if (this.codec == null) {
                throw new IllegalArgumentException("Codec is mandatory");
            }
            if (this.shardFunction == null) {
                this.shardFunction = this.shardBy == null ? item -> ArithmeticUtils.getShardByHash(item, this.workers.size()) : item -> ArithmeticUtils.getShardByHash(this.shardBy.apply(item), this.workers.size());
            }
            return new DistributedShufflerConfig(this);
        }
    }
}

