/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.inter.AsyncCompoundPipe;
import org.pipecraft.pipes.async.inter.SyncToAsyncPipe;
import org.pipecraft.pipes.utils.multi.LocalMultiFileReaderConfig;
import org.pipecraft.pipes.utils.multi.MultiFileReaderUtils;

public class AsyncMultiFileReaderPipe<T>
extends AsyncCompoundPipe<T> {
    private final LocalMultiFileReaderConfig<T> config;

    public AsyncMultiFileReaderPipe(LocalMultiFileReaderConfig<T> config) {
        this.config = config;
    }

    @Override
    protected AsyncPipe<T> createPipeline() throws IOException {
        Collection<File> filesToRead = MultiFileReaderUtils.getAllLocalFilesToRead(this.config);
        ArrayList pipesSuppliers = new ArrayList();
        for (File f : filesToRead) {
            pipesSuppliers.add(() -> this.config.getPipeSupplier().get(new SizedInputStream(new FileInputStream(f), f.length()), f));
        }
        return new SyncToAsyncPipe(pipesSuppliers, this.config.getThreadNum());
    }
}

