/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.async.source;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.inter.AsyncCompoundPipe;
import org.pipecraft.pipes.async.inter.SyncToAsyncPipe;
import org.pipecraft.pipes.utils.PipeSupplier;
import org.pipecraft.pipes.utils.multi.MultiFileReaderUtils;
import org.pipecraft.pipes.utils.multi.StorageMultiFileReaderConfig;

public class AsyncStorageMultiFileReaderPipe<T, B>
extends AsyncCompoundPipe<T> {
    private final StorageMultiFileReaderConfig<T, B> config;

    public AsyncStorageMultiFileReaderPipe(StorageMultiFileReaderConfig<T, B> config) {
        this.config = config;
    }

    @Override
    protected AsyncPipe<T> createPipeline() throws IOException {
        try {
            List<PipeSupplier<T>> pipesSuppliers;
            Collection<B> files = MultiFileReaderUtils.getAllRemoteFilesToRead(this.config);
            Bucket<B> bucket = this.config.getBucket();
            if (this.config.isDownloadFirst()) {
                pipesSuppliers = MultiFileReaderUtils.downloadAndGetReadPipes(files, bucket, this.config);
            } else {
                pipesSuppliers = new ArrayList<PipeSupplier<T>>(files.size());
                for (B f : files) {
                    pipesSuppliers.add(() -> {
                        SizedInputStream is = bucket.getAsStream(f);
                        return this.config.getPipeSupplier().get(is, f);
                    });
                }
            }
            return new SyncToAsyncPipe<T>(pipesSuppliers, this.config.getThreadNum());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }
}

