/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.AvroDecoder;
import org.pipecraft.pipes.serialization.AvroEncoder;
import org.pipecraft.pipes.serialization.CodecFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class AvroCodecFactory<T>
implements CodecFactory<T> {
    private final Class<T> clazz;

    public AvroCodecFactory(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ItemEncoder<T> newEncoder(OutputStream os, FileWriteOptions writeOptions) throws IOException {
        return new AvroEncoder<T>(this.clazz, FileUtils.getCompressionOutputStream(os, writeOptions.getCompression()));
    }

    @Override
    public ItemDecoder<T> newDecoder(InputStream is, FileReadOptions readOptions) throws IOException {
        return new AvroDecoder<T>(this.clazz, FileUtils.getCompressionInputStream(is, readOptions.getCompression()));
    }
}

