/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;

public class AvroDecoder<T>
implements ItemDecoder<T> {
    private final InputStream is;
    private final DatumReader<T> reader;
    private final BinaryDecoder decoder;

    public AvroDecoder(Class<T> clazz, InputStream is) throws IOException {
        this(ReflectData.get().getSchema(clazz), is, new FileReadOptions());
    }

    private AvroDecoder(Schema schema, InputStream is, FileReadOptions options) throws IOException {
        this.reader = new ReflectDatumReader(schema);
        org.apache.avro.io.DecoderFactory factory = new org.apache.avro.io.DecoderFactory();
        factory.configureDecoderBufferSize(options.getBufferSize());
        this.is = FileUtils.getCompressionInputStream(is, options.getCompression());
        this.decoder = factory.binaryDecoder(is, null);
    }

    @Override
    public T decode() throws IOException {
        if (this.decoder.isEnd()) {
            return null;
        }
        return (T)this.reader.read(null, (Decoder)this.decoder);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public static <R> DecoderFactory<R> getFactory(Class<R> clazz) {
        return new Factory<R>(clazz);
    }

    private static class Factory<R>
    implements DecoderFactory<R> {
        private final Schema schema;

        public Factory(Class<R> clazz) {
            this.schema = ReflectData.get().getSchema(clazz);
        }

        @Override
        public ItemDecoder<R> newDecoder(InputStream is, FileReadOptions options) throws IOException {
            return new AvroDecoder(this.schema, is, options);
        }
    }
}

