/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class AvroEncoder<T>
implements ItemEncoder<T> {
    private final DatumWriter<T> writer;
    private final BinaryEncoder encoder;
    private final OutputStream os;

    public AvroEncoder(Class<T> clazz, OutputStream os) throws IOException {
        this(ReflectData.get().getSchema(clazz), os, new FileWriteOptions());
    }

    private AvroEncoder(Schema schema, OutputStream os, FileWriteOptions options) throws IOException {
        this.writer = new ReflectDatumWriter(schema);
        org.apache.avro.io.EncoderFactory factory = new org.apache.avro.io.EncoderFactory();
        factory.configureBufferSize(options.getBufferSize());
        this.os = FileUtils.getCompressionOutputStream(os, options.getCompression(), options.getCompressionLevel());
        this.encoder = factory.binaryEncoder(os, null);
    }

    @Override
    public void close() throws IOException {
        this.encoder.flush();
        this.os.close();
    }

    @Override
    public void encode(T item) throws IOException {
        this.writer.write(item, (Encoder)this.encoder);
    }

    public static <R> EncoderFactory<R> getFactory(Class<R> clazz) {
        return new Factory<R>(clazz);
    }

    private static class Factory<R>
    implements EncoderFactory<R> {
        private final Schema schema;

        public Factory(Class<R> clazz) {
            this.schema = ReflectData.get().getSchema(clazz);
        }

        @Override
        public ItemEncoder<R> newEncoder(OutputStream os, FileWriteOptions options) throws IOException {
            return new AvroEncoder(this.schema, os, options);
        }
    }
}

