/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.IOException;
import java.io.InputStream;
import org.pipecraft.infra.io.Coding;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.serialization.AbstractInputStreamItemDecoder;
import org.pipecraft.pipes.serialization.ItemDecoder;

public interface ByteArrayDecoder<T> {
    public T decode(byte[] var1) throws ValidationPipeException;

    default public ItemDecoder<T> newFixedRecSizeDecoder(InputStream is, FileReadOptions readOptions, final int recSize) throws IOException {
        return new AbstractInputStreamItemDecoder<T>(is, readOptions){
            private final byte[] buffer;
            {
                super(is, readOptions);
                this.buffer = new byte[recSize];
            }

            @Override
            public T decode() throws IOException, ValidationPipeException {
                if (!Coding.tryRead(this.is, this.buffer, 0, recSize)) {
                    return null;
                }
                return ByteArrayDecoder.this.decode(this.buffer);
            }
        };
    }
}

