/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;

public class CSVDecoder<T>
implements ItemDecoder<T> {
    private static final char DEFAULT_DELIMITER = ',';
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final BufferedReader reader;
    private final CsvParser csvReader;
    private final FailableFunction<String[], T, ValidationPipeException> itemDetextualizer;

    public CSVDecoder(InputStream is, FailableFunction<String[], T, ValidationPipeException> itemDetextualizer, Charset charset, char delimiter, int rowsToSkip, FileReadOptions readOptions) throws IOException {
        this.itemDetextualizer = itemDetextualizer;
        CsvParserSettings settings = new CsvParserSettings();
        settings.setIgnoreLeadingWhitespaces(false);
        settings.setIgnoreTrailingWhitespaces(false);
        settings.setMaxCharsPerColumn(-1);
        settings.setNumberOfRowsToSkip((long)rowsToSkip);
        settings.setEmptyValue("");
        CsvFormat format = (CsvFormat)settings.getFormat();
        format.setDelimiter(delimiter);
        format.setLineSeparator("\n");
        this.reader = FileUtils.getReader(is, charset, readOptions);
        this.csvReader = new CsvParser(settings);
        this.csvReader.beginParsing((Reader)this.reader);
    }

    public CSVDecoder(InputStream is, FailableFunction<String[], T, ValidationPipeException> itemDetextualizer, int rowsToSkip) throws IOException {
        this(is, itemDetextualizer, DEFAULT_CHARSET, ',', rowsToSkip, new FileReadOptions());
    }

    public CSVDecoder(InputStream is, FailableFunction<String[], T, ValidationPipeException> itemDetextualizer) throws IOException {
        this(is, itemDetextualizer, DEFAULT_CHARSET, ',', 0, new FileReadOptions());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public T decode() throws IOException, ValidationPipeException {
        String[] line = this.csvReader.parseNext();
        if (line == null) {
            return null;
        }
        return this.itemDetextualizer.apply(line);
    }

    public static <R> DecoderFactory<R> getFactory(FailableFunction<String[], R, ValidationPipeException> itemDetextualizer, Charset charset, char delimiter, int rowsToSkip) {
        return new Factory<R>(itemDetextualizer, charset, delimiter, rowsToSkip);
    }

    public static <R> DecoderFactory<R> getFactory(FailableFunction<String[], R, ValidationPipeException> itemDetextualizer) {
        return new Factory<R>(itemDetextualizer, DEFAULT_CHARSET, ',', 0);
    }

    private static class Factory<R>
    implements DecoderFactory<R> {
        private final FailableFunction<String[], R, ValidationPipeException> itemDetextualizer;
        private final Charset charset;
        private final char delimiter;
        private final int rowsToSkip;

        public Factory(FailableFunction<String[], R, ValidationPipeException> itemDetextualizer, Charset charset, char delimiter, int rowsToSkip) {
            this.itemDetextualizer = itemDetextualizer;
            this.charset = charset;
            this.delimiter = delimiter;
            this.rowsToSkip = rowsToSkip;
        }

        @Override
        public ItemDecoder<R> newDecoder(InputStream is, FileReadOptions options) throws IOException {
            return new CSVDecoder<R>(is, this.itemDetextualizer, this.charset, this.delimiter, this.rowsToSkip, options);
        }
    }
}

