/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.serialization.EncoderFactory;
import org.pipecraft.pipes.serialization.ItemEncoder;

public class CSVEncoder<T>
implements ItemEncoder<T> {
    private static final char DEFAULT_DELIMITER = ',';
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final CsvWriter csvWriter;
    private final Function<T, String[]> itemTextualizer;

    public CSVEncoder(OutputStream os, Function<T, String[]> itemTextualizer, Charset charset, char delimiter, String headerBlock, FileWriteOptions writeOptions) throws IOException {
        this.itemTextualizer = itemTextualizer;
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.setIgnoreLeadingWhitespaces(false);
        settings.setIgnoreTrailingWhitespaces(false);
        settings.setMaxCharsPerColumn(-1);
        settings.setEmptyValue("\"\"");
        CsvFormat format = (CsvFormat)settings.getFormat();
        format.setDelimiter(delimiter);
        format.setLineSeparator("\n");
        BufferedWriter writer = FileUtils.getWriter(os, charset, writeOptions);
        if (headerBlock != null) {
            writer.write(headerBlock);
            writer.write(10);
        }
        this.csvWriter = new CsvWriter((Writer)writer, settings);
    }

    public CSVEncoder(OutputStream os, Function<T, String[]> itemTextualizer) throws IOException {
        this(os, itemTextualizer, DEFAULT_CHARSET, ',', null, new FileWriteOptions());
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.flush();
        this.csvWriter.close();
    }

    @Override
    public void encode(T item) throws IOException {
        String[] columns = this.itemTextualizer.apply(item);
        this.csvWriter.writeRow(columns);
    }

    public static <R> EncoderFactory<R> getFactory(Function<R, String[]> itemTextualizer, Charset charset, char delimiter, String headerBlock) {
        return new Factory<R>(itemTextualizer, charset, delimiter, headerBlock);
    }

    public static <R> EncoderFactory<R> getFactory(Function<R, String[]> itemTextualizer) {
        return new Factory<R>(itemTextualizer, DEFAULT_CHARSET, ',', null);
    }

    private static class Factory<R>
    implements EncoderFactory<R> {
        private final Function<R, String[]> itemTextualizer;
        private final Charset charset;
        private final char delimiter;
        private final String headerBlock;

        public Factory(Function<R, String[]> itemTextualizer, Charset charset, char delimiter, String headerBlock) {
            this.itemTextualizer = itemTextualizer;
            this.charset = charset;
            this.delimiter = delimiter;
            this.headerBlock = headerBlock;
        }

        @Override
        public ItemEncoder<R> newEncoder(OutputStream os, FileWriteOptions options) throws IOException {
            return new CSVEncoder<R>(os, this.itemTextualizer, this.charset, this.delimiter, this.headerBlock, options);
        }
    }
}

