/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.pipes.serialization.ByteArrayDecoder;
import org.pipecraft.pipes.serialization.ItemDecoder;

public interface DecoderFactory<T> {
    public ItemDecoder<T> newDecoder(InputStream var1, FileReadOptions var2) throws IOException;

    default public ItemDecoder<T> newDecoder(InputStream is) throws IOException {
        return this.newDecoder(is, new FileReadOptions());
    }

    default public ByteArrayDecoder<T> newByteArrayDecoder() {
        return bytes -> {
            T t;
            block8: {
                ItemDecoder<T> decoder = this.newDecoder(new ByteArrayInputStream(bytes));
                try {
                    t = decoder.decode();
                    if (decoder == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (decoder != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                decoder.close();
            }
            return t;
        };
    }
}

