/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import org.pipecraft.infra.io.Coding;
import org.pipecraft.pipes.serialization.ByteArrayDecoder;
import org.pipecraft.pipes.serialization.DecoderFactory;

public class IntDecoders {
    public static final DecoderFactory<Integer> INT16_BE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Integer>)bytes -> Coding.readBigEndian16(bytes, 0)).newFixedRecSizeDecoder(is, options, 2);
    public static final DecoderFactory<Integer> INT16_LE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Integer>)bytes -> Coding.readLittleEndian16(bytes, 0)).newFixedRecSizeDecoder(is, options, 2);
    public static final DecoderFactory<Integer> INT32_BE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Integer>)bytes -> Coding.readBigEndian32(bytes, 0)).newFixedRecSizeDecoder(is, options, 4);
    public static final DecoderFactory<Integer> INT32_LE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Integer>)bytes -> Coding.readLittleEndian32(bytes, 0)).newFixedRecSizeDecoder(is, options, 4);
    public static final DecoderFactory<Long> INT64_BE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Long>)bytes -> Coding.readBigEndian64(bytes, 0)).newFixedRecSizeDecoder(is, options, 8);
    public static final DecoderFactory<Long> INT64_LE_DECODER_FACTORY = (is, options) -> ((ByteArrayDecoder<Long>)bytes -> Coding.readLittleEndian64(bytes, 0)).newFixedRecSizeDecoder(is, options, 8);
}

