/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.serialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.serialization.ByteArrayDecoder;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;

public class TxtDecoderFactory<T>
implements DecoderFactory<T> {
    private final FailableFunction<String, T, ? extends ValidationPipeException> itemDetextualizer;
    private final Charset charset;

    public TxtDecoderFactory(FailableFunction<String, T, ? extends ValidationPipeException> itemDetextualizer, Charset charset) {
        this.itemDetextualizer = itemDetextualizer;
        this.charset = charset;
    }

    public TxtDecoderFactory(FailableFunction<String, T, ? extends ValidationPipeException> itemDetextualizer) {
        this(itemDetextualizer, StandardCharsets.UTF_8);
    }

    @Override
    public ItemDecoder<T> newDecoder(InputStream is, FileReadOptions readOptions) throws IOException {
        return new Decoder(is, readOptions);
    }

    @Override
    public ByteArrayDecoder<T> newByteArrayDecoder() {
        return bytes -> {
            String itemAsText = new String(bytes, this.charset);
            return this.itemDetextualizer.apply(itemAsText);
        };
    }

    private class Decoder
    implements ItemDecoder<T> {
        private final BufferedReader reader;

        public Decoder(InputStream is, FileReadOptions options) throws IOException {
            this.reader = FileUtils.getReader(is, TxtDecoderFactory.this.charset, options);
        }

        @Override
        public T decode() throws IOException, ValidationPipeException {
            String itemAsText = this.reader.readLine();
            if (itemAsText == null) {
                return null;
            }
            return TxtDecoderFactory.this.itemDetextualizer.apply(itemAsText);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

