/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class CountPipe
implements Pipe<Integer> {
    private final Pipe<?> input;
    private Integer count;

    public CountPipe(Pipe<?> input) {
        this.input = input;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        int count = 0;
        while (this.input.next() != null) {
            ++count;
        }
        this.count = count;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public Integer next() throws PipeException, InterruptedException {
        Integer res = this.count;
        this.count = null;
        return res;
    }

    @Override
    public Integer peek() {
        return this.count;
    }

    @Override
    public float getProgress() {
        return 1.0f;
    }
}

