/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public abstract class FilterBasePipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private T next;

    public FilterBasePipe(Pipe<T> input) {
        this.input = input;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }

    protected abstract boolean shouldSelect(T var1);

    private void prepareNext() throws PipeException, InterruptedException {
        while ((this.next = this.input.next()) != null && !this.shouldSelect(this.next)) {
        }
    }
}

