/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.CodecFactory;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.FlexibleMapPipe;
import org.pipecraft.pipes.sync.inter.reduct.HashReductorPipe;
import org.pipecraft.pipes.sync.inter.reduct.ReductorConfig;
import org.pipecraft.pipes.sync.source.CollectionReaderPipe;

public class GrouperPipe<T>
extends CompoundPipe<T> {
    private final Pipe<T> input;
    private final FailableFunction<T, Object, PipeException> discriminator;
    private final CodecFactory<T> inputCodec;
    private final int partitionCount;
    private final File tmpFolder;

    public GrouperPipe(Pipe<T> input, FailableFunction<T, ?, PipeException> discriminator, CodecFactory<T> inputCodec, int partitionCount, File tmpFolder) {
        this.input = input;
        this.discriminator = discriminator;
        this.inputCodec = inputCodec;
        this.partitionCount = partitionCount;
        this.tmpFolder = tmpFolder;
    }

    @Override
    protected Pipe<T> createPipeline() throws PipeException, InterruptedException {
        HashReductorPipe reductorP = new HashReductorPipe(this.input, this.inputCodec, this.partitionCount, this.tmpFolder, ReductorConfig.builder().discriminator(this.discriminator).aggregatorCreator(f -> new ArrayList()).aggregationLogic(List::add).postProcessor(Function.identity()).build());
        return new FlexibleMapPipe(reductorP, CollectionReaderPipe::new);
    }
}

