/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class HeadPipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private final int totalCount;
    private volatile int remainingCount;
    private T next;

    public HeadPipe(Pipe<T> input, int n) {
        this.input = input;
        this.totalCount = n;
        this.remainingCount = n;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    private void prepareNext() throws PipeException, InterruptedException {
        if (this.remainingCount == 0) {
            this.next = null;
        } else {
            --this.remainingCount;
            this.next = this.input.next();
        }
    }

    @Override
    public float getProgress() {
        if (this.totalCount == 0) {
            return 1.0f;
        }
        return 1.0f - (float)this.remainingCount / (float)this.totalCount;
    }
}

