/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.Comparator;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.sync.Pipe;

public class OrderValidationPipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private final Comparator<T> comparator;
    private T next;

    public OrderValidationPipe(Pipe<T> input, Comparator<T> comparator) {
        this.input = input;
        this.comparator = comparator;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T currentItem = this.next;
        this.next = this.input.next();
        if (this.next != null && this.comparator.compare(currentItem, this.next) > 0) {
            throw new ValidationPipeException("Encountered two non ordered elements");
        }
        return currentItem;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    private void prepareNext() throws PipeException, InterruptedException {
        this.next = this.input.next();
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

