/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.join;

import java.util.BitSet;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.join.JoinRecord;
import org.pipecraft.pipes.utils.PipeUtils;

public enum JoinMode {
    LEFT((r, c) -> r.getLeft().size() > 0, (l, r) -> Float.valueOf(l.getProgress()), (p, c) -> !p.get(0)),
    INNER((r, c) -> r.getLeft().size() > 0 && r.getRight().size() > 0, (l, r) -> Float.valueOf(Math.max(l.getProgress(), PipeUtils.getMinProgress(r))), (p, c) -> !p.get(0) || p.nextSetBit(1) == -1),
    FULL_INNER((r, c) -> r.getLeft().size() > 0 && r.getRight().size() == c.intValue(), (l, r) -> Float.valueOf(Math.max(l.getProgress(), PipeUtils.getMaxProgress(r))), (p, c) -> p.cardinality() < c + 1),
    OUTER((r, c) -> true, (l, r) -> Float.valueOf(Math.min(l.getProgress(), PipeUtils.getMinProgress(r))), (p, c) -> p.isEmpty());

    private final BiPredicate<JoinRecord<?, ?, ?>, Integer> selector;
    private final BiFunction<Pipe<?>, Collection<? extends Pipe<?>>, Float> progressResolver;
    private final BiPredicate<BitSet, Integer> earlyExitPredicate;

    private JoinMode(BiPredicate<JoinRecord<?, ?, ?>, Integer> selector, BiFunction<Pipe<?>, Collection<? extends Pipe<?>>, Float> progressResolver, BiPredicate<BitSet, Integer> earlyExitPredicate) {
        this.selector = selector;
        this.progressResolver = progressResolver;
        this.earlyExitPredicate = earlyExitPredicate;
    }

    public boolean shouldOutput(JoinRecord<?, ?, ?> joinRec, int rightPipeCount) {
        return this.selector.test(joinRec, rightPipeCount);
    }

    public float resolveProgress(Pipe<?> leftPipe, Collection<? extends Pipe<?>> rightPipes) {
        return this.progressResolver.apply(leftPipe, rightPipes).floatValue();
    }

    public boolean canEarlyExit(BitSet activePipes, int rightPipeCount) {
        return this.earlyExitPredicate.test(activePipes, rightPipeCount);
    }
}

