/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class JoinRecord<K, L, R> {
    private final K key;
    private final List<L> left;
    private final Map<Integer, List<R>> right;
    private int itemsCount;

    JoinRecord(K key, List<L> left, Map<Integer, List<R>> right) {
        this.key = key;
        this.left = left;
        this.itemsCount += left.size();
        this.right = new TreeMap<Integer, List<R>>(right);
        right.values().forEach(l -> this.itemsCount += l.size());
    }

    JoinRecord(K key) {
        this.key = key;
        this.left = new ArrayList<L>();
        this.right = new TreeMap<Integer, List<R>>();
    }

    public K getKey() {
        return this.key;
    }

    void addLeft(L item) {
        this.left.add(item);
        ++this.itemsCount;
    }

    public List<L> getLeft() {
        return this.left;
    }

    public L getSingleLeft() {
        return this.left.size() > 0 ? (L)this.left.get(0) : null;
    }

    void addRight(int id, R item) {
        this.right.computeIfAbsent(id, ArrayList::new).add(item);
        ++this.itemsCount;
    }

    public int getItemsCount() {
        return this.itemsCount;
    }

    public Map<Integer, List<R>> getRight() {
        return this.right;
    }

    public R getSingleRight() {
        List<R> list = this.right.get(0);
        return list == null ? null : (R)list.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinRecord that = (JoinRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.left, this.right);
    }

    public String toString() {
        return "JoinRecord [key=" + this.key + ", left=" + this.left + ", right=" + this.right + "]";
    }
}

