/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.join.JoinMode;
import org.pipecraft.pipes.sync.inter.join.JoinRecord;
import org.pipecraft.pipes.sync.source.EmptyPipe;

public class LookupJoinPipe<K, L, R>
implements Pipe<JoinRecord<K, L, R>> {
    private final Pipe<L> leftPipe;
    private final FailableFunction<L, K, PipeException> leftKeyExtractor;
    private final List<? extends Pipe<R>> rightPipes;
    private final FailableFunction<R, K, PipeException> rightKeyExtractor;
    private final JoinMode joinMode;
    private HashMap<K, RightSideMatches<R>> rightLookup;
    private Iterator<Map.Entry<K, RightSideMatches<R>>> rightIter;
    private JoinRecord<K, L, R> next;

    public LookupJoinPipe(Pipe<L> leftPipe, FailableFunction<L, K, PipeException> leftKeyExtractor, List<? extends Pipe<R>> rightPipes, FailableFunction<R, K, PipeException> rightKeyExtractor, JoinMode joinMode) {
        this.leftPipe = leftPipe;
        this.leftKeyExtractor = leftKeyExtractor;
        this.rightPipes = rightPipes;
        this.rightKeyExtractor = rightKeyExtractor;
        this.joinMode = joinMode;
    }

    public LookupJoinPipe(Pipe<L> leftPipe, FailableFunction<L, K, PipeException> leftKeyExtractor, Pipe<R> rightPipe, FailableFunction<R, K, PipeException> rightKeyExtractor, JoinMode joinMode) {
        this(leftPipe, leftKeyExtractor, Collections.singletonList(rightPipe), rightKeyExtractor, joinMode);
    }

    public LookupJoinPipe(List<? extends Pipe<R>> rightPipes, FailableFunction<R, K, PipeException> rightKeyExtractor) {
        this((Pipe<Object>)EmptyPipe.instance(), (FailableFunction<Object, Object, PipeException>)v -> null, (List<Pipe<R>>)rightPipes, (FailableFunction<R, Object, PipeException>)rightKeyExtractor, JoinMode.OUTER);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.rightLookup = new HashMap();
        for (int pipeInd = 0; pipeInd < this.rightPipes.size(); ++pipeInd) {
            R rNext;
            Pipe<R> rPipe = this.rightPipes.get(pipeInd);
            rPipe.start();
            while ((rNext = rPipe.next()) != null) {
                K key = this.rightKeyExtractor.apply(rNext);
                RightSideMatches rMatches = this.rightLookup.computeIfAbsent(key, k -> new RightSideMatches(this.rightPipes.size()));
                List l = rMatches.matches[pipeInd];
                if (l == null) {
                    l = new ArrayList();
                    rMatches.matches[pipeInd] = l;
                }
                l.add(rNext);
            }
        }
        this.leftPipe.start();
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        IOException lastExc = null;
        try {
            this.leftPipe.close();
        }
        catch (IOException e) {
            lastExc = e;
        }
        for (Pipe<R> p : this.rightPipes) {
            try {
                p.close();
            }
            catch (IOException e) {
                lastExc = e;
            }
        }
        if (lastExc != null) {
            throw lastExc;
        }
    }

    @Override
    public JoinRecord<K, L, R> next() throws PipeException, InterruptedException {
        JoinRecord<K, L, R> toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public JoinRecord<K, L, R> peek() {
        return this.next;
    }

    private void prepareNext() throws PipeException, InterruptedException {
        L lNext = this.leftPipe.next();
        if (lNext == null) {
            if (this.joinMode == JoinMode.OUTER) {
                if (this.rightIter == null) {
                    this.rightIter = this.rightLookup.entrySet().iterator();
                }
                while (this.rightIter.hasNext()) {
                    Map.Entry<K, RightSideMatches<R>> entry = this.rightIter.next();
                    RightSideMatches<R> rMatches = entry.getValue();
                    if (rMatches.visited) continue;
                    JoinRecord joinRec = new JoinRecord(entry.getKey());
                    for (int id = 0; id < this.rightPipes.size(); ++id) {
                        List pipeMatches = rMatches.matches[id];
                        if (pipeMatches == null) continue;
                        for (Object item : pipeMatches) {
                            joinRec.addRight(id, item);
                        }
                    }
                    if (!this.joinMode.shouldOutput(joinRec, this.rightPipes.size())) continue;
                    this.next = joinRec;
                    return;
                }
            }
        } else {
            do {
                K key = this.leftKeyExtractor.apply(lNext);
                JoinRecord joinRec = new JoinRecord(key);
                joinRec.addLeft(lNext);
                RightSideMatches<R> right = this.rightLookup.get(key);
                if (right != null) {
                    right.visited = true;
                    for (int pipeInd = 0; pipeInd < right.matches.length; ++pipeInd) {
                        List pipeMatches = right.matches[pipeInd];
                        if (pipeMatches == null) continue;
                        for (Object rMatch : pipeMatches) {
                            joinRec.addRight(pipeInd, rMatch);
                        }
                    }
                }
                if (!this.joinMode.shouldOutput(joinRec, this.rightPipes.size())) continue;
                this.next = joinRec;
                return;
            } while ((lNext = this.leftPipe.next()) != null);
        }
        this.next = null;
    }

    @Override
    public float getProgress() {
        return this.joinMode.resolveProgress(this.leftPipe, this.rightPipes);
    }

    private static class RightSideMatches<R> {
        private final List<R>[] matches;
        private boolean visited;

        public RightSideMatches(int size) {
            this.matches = new List[size];
        }
    }
}

