/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.reduct;

import java.util.function.Function;
import org.pipecraft.infra.concurrent.FailableBiConsumer;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;

public class ReductorConfig<I, F, G, O> {
    private final FailableFunction<I, F, PipeException> discriminator;
    private final Function<F, G> aggregatorCreator;
    private final FailableBiConsumer<G, I, PipeException> aggregationLogic;
    private final Function<G, O> postProcessor;

    private ReductorConfig(FailableFunction<I, F, PipeException> discriminator, Function<F, G> aggregatorCreator, FailableBiConsumer<G, I, PipeException> aggregationLogic, Function<G, O> postProcessor) {
        this.discriminator = discriminator;
        this.aggregatorCreator = aggregatorCreator;
        this.aggregationLogic = aggregationLogic;
        this.postProcessor = postProcessor;
    }

    public static <I, F, G, O> Builder<I, F, G, O> builder() {
        return new Builder();
    }

    public FailableFunction<I, F, PipeException> getDiscriminator() {
        return this.discriminator;
    }

    public Function<F, G> getAggregatorCreator() {
        return this.aggregatorCreator;
    }

    public FailableBiConsumer<G, I, PipeException> getAggregationLogic() {
        return this.aggregationLogic;
    }

    public Function<G, O> getPostProcessor() {
        return this.postProcessor;
    }

    public static class Builder<I, F, G, O> {
        private FailableFunction<I, F, PipeException> discriminator;
        private Function<F, G> aggregatorCreator;
        private FailableBiConsumer<G, I, PipeException> aggregationLogic;
        private Function<G, O> postProcessor;

        private Builder() {
        }

        public Builder<I, F, G, O> discriminator(FailableFunction<I, F, PipeException> discriminator) {
            this.discriminator = discriminator;
            return this;
        }

        public Builder<I, F, G, O> aggregatorCreator(Function<F, G> aggregatorCreator) {
            this.aggregatorCreator = aggregatorCreator;
            return this;
        }

        public Builder<I, F, G, O> aggregationLogic(FailableBiConsumer<G, I, PipeException> aggregationLogic) {
            this.aggregationLogic = aggregationLogic;
            return this;
        }

        public Builder<I, F, G, O> postProcessor(Function<G, O> postProcessor) {
            this.postProcessor = postProcessor;
            return this;
        }

        public FailableFunction<I, F, PipeException> getDiscriminator() {
            return this.discriminator;
        }

        public Function<F, G> getAggregatorCreator() {
            return this.aggregatorCreator;
        }

        public FailableBiConsumer<G, I, PipeException> getAggregationLogic() {
            return this.aggregationLogic;
        }

        public Function<G, O> getPostProcessor() {
            return this.postProcessor;
        }

        public ReductorConfig<I, F, G, O> build() {
            return new ReductorConfig<I, F, G, O>(this.discriminator, this.aggregatorCreator, this.aggregationLogic, this.postProcessor);
        }
    }
}

