/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.reduct;

import java.io.IOException;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.reduct.ReductorConfig;

public class SequenceReductorPipe<I, O>
implements Pipe<O> {
    private final Pipe<I> input;
    private final ReductorConfig<I, Object, Object, O> reductorConfig;
    private O next;

    public SequenceReductorPipe(Pipe<I> input, ReductorConfig<I, ?, ?, O> reductorConfig) {
        this.input = input;
        this.reductorConfig = reductorConfig;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public O next() throws PipeException, InterruptedException {
        O res = this.next;
        this.prepareNext();
        return res;
    }

    @Override
    public O peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    private void prepareNext() throws PipeException, InterruptedException {
        I v;
        I peeked = this.input.peek();
        if (peeked == null) {
            this.next = null;
            return;
        }
        FailableFunction<I, Object, PipeException> discriminator = this.reductorConfig.getDiscriminator();
        Object familyId = discriminator.apply(peeked);
        Object aggregator = this.reductorConfig.getAggregatorCreator().apply(familyId);
        while ((v = this.input.peek()) != null && discriminator.apply(v).equals(familyId)) {
            this.input.next();
            this.reductorConfig.getAggregationLogic().accept(aggregator, v);
        }
        this.next = this.reductorConfig.getPostProcessor().apply(aggregator);
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

