/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.sample;

import java.util.Random;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.FilterBasePipe;

public class ExactSamplerPipe<T>
extends FilterBasePipe<T> {
    private final Random rnd;
    private long remaining;
    private long remainingToSample;

    public ExactSamplerPipe(Pipe<T> input, int n, int m, Random rnd) {
        super(input);
        this.remaining = n;
        this.remainingToSample = m;
        this.rnd = rnd;
    }

    public ExactSamplerPipe(Pipe<T> input, int n, int m) {
        this(input, n, m, new Random());
    }

    @Override
    protected boolean shouldSelect(T item) {
        if (this.rnd.nextDouble() < (double)this.remainingToSample / (double)this.remaining) {
            --this.remaining;
            --this.remainingToSample;
            return true;
        }
        --this.remaining;
        return false;
    }
}

