/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.ConcatPipe;
import org.pipecraft.pipes.utils.multi.LocalMultiFileReaderConfig;
import org.pipecraft.pipes.utils.multi.MultiFileReaderUtils;

public class MultiFileReaderPipe<T>
extends CompoundPipe<T> {
    private final LocalMultiFileReaderConfig<T> config;

    public MultiFileReaderPipe(LocalMultiFileReaderConfig<T> config) {
        this.config = config;
    }

    @Override
    protected Pipe<T> createPipeline() throws PipeException, InterruptedException {
        try {
            Collection<File> filesToRead = MultiFileReaderUtils.getAllLocalFilesToRead(this.config);
            if (this.config.getFileOrder() != null) {
                ArrayList<File> sortedFiles = new ArrayList<File>(filesToRead);
                Collections.sort(sortedFiles, this.config.getFileOrder());
                filesToRead = sortedFiles;
            }
            ArrayList pipesSuppliers = new ArrayList();
            for (File f : filesToRead) {
                pipesSuppliers.add(() -> this.config.getPipeSupplier().get(new SizedInputStream(new FileInputStream(f), f.length()), f));
            }
            return new ConcatPipe(pipesSuppliers);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

