/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.ConcatPipe;
import org.pipecraft.pipes.sync.source.TxtFileReaderPipe;
import org.pipecraft.pipes.utils.PipeSupplier;

public class MultiTxtFileReaderPipe
extends CompoundPipe<String> {
    private final File folder;
    private final Charset charset;
    private final int bufferSize;
    private final String fileRegex;
    private final Comparator<File> comparator;

    public MultiTxtFileReaderPipe(File folder, Charset charset, int bufferSize, String fileRegex, Comparator<File> comparator) {
        this.folder = folder;
        this.charset = charset;
        this.bufferSize = bufferSize;
        this.fileRegex = fileRegex;
        this.comparator = comparator;
    }

    public MultiTxtFileReaderPipe(File folder, Comparator<File> comparator) {
        this(folder, StandardCharsets.UTF_8, 0, ".*", comparator);
    }

    public MultiTxtFileReaderPipe(File folder) {
        this(folder, StandardCharsets.UTF_8, 0, ".*", Comparator.comparing(File::getName));
    }

    @Override
    protected Pipe<String> createPipeline() throws PipeException, InterruptedException {
        List pipeGenList = this.getPipeGenList();
        return new ConcatPipe<String>(pipeGenList);
    }

    private List<PipeSupplier<String>> getPipeGenList() {
        File[] files = this.folder.listFiles(f -> f.getName().matches(this.fileRegex));
        Arrays.sort(files, this.comparator);
        ArrayList<PipeSupplier<String>> res = new ArrayList<PipeSupplier<String>>();
        for (File f2 : files) {
            FileReadOptions options = new FileReadOptions().detectCompression(f2.getName());
            if (this.bufferSize > 0) {
                options.buffer(this.bufferSize);
            }
            res.add(() -> new TxtFileReaderPipe(f2, this.charset, options));
        }
        return res;
    }
}

