/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class ReaderPipe
implements Pipe<String> {
    private final BufferedReader reader;
    private String next;
    private volatile boolean done;

    public ReaderPipe(Reader r) {
        this.reader = new BufferedReader(r);
    }

    public ReaderPipe(Reader r, int bufferSize) {
        this.reader = new BufferedReader(r, bufferSize);
    }

    @Override
    public void start() throws PipeException {
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public String next() throws PipeException {
        String toReturn = this.next;
        this.prepareNext();
        if (this.next == null) {
            this.done = true;
        }
        return toReturn;
    }

    @Override
    public String peek() {
        return this.next;
    }

    private void prepareNext() throws PipeException {
        try {
            this.next = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public float getProgress() {
        if (this.done) {
            return 1.0f;
        }
        return 0.0f;
    }
}

