/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.util.function.Function;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class SeqGenPipe<T>
implements Pipe<T> {
    private final Function<Long, T> generator;
    private final long totalCount;
    private volatile long pos;
    private T next;

    public SeqGenPipe(Function<Long, T> generator) {
        this(generator, Long.MAX_VALUE);
    }

    public SeqGenPipe(Function<Long, T> generator, long count) {
        this.generator = generator;
        this.totalCount = count;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    private void prepareNext() {
        this.next = this.pos < this.totalCount ? this.generator.apply(this.pos++) : null;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.prepareNext();
    }

    @Override
    public float getProgress() {
        if (this.totalCount == 0L) {
            return 1.0f;
        }
        if (this.totalCount == Long.MAX_VALUE) {
            return 0.0f;
        }
        return (float)this.pos / (float)this.totalCount;
    }
}

