/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.ConcatPipe;
import org.pipecraft.pipes.utils.multi.LocalMultiFileReaderConfig;
import org.pipecraft.pipes.utils.multi.MultiFileReaderUtils;
import org.pipecraft.pipes.utils.multi.StorageMultiFileReaderConfig;

public class StorageMultiFileReaderPipe<T, B>
extends CompoundPipe<T> {
    private final StorageMultiFileReaderConfig<T, B> config;

    public StorageMultiFileReaderPipe(StorageMultiFileReaderConfig<T, B> config) {
        if (config.getBucket() == null) {
            throw new IllegalArgumentException("Missing storage bucket in " + LocalMultiFileReaderConfig.class.getSimpleName());
        }
        this.config = config;
    }

    @Override
    protected Pipe<T> createPipeline() throws PipeException, InterruptedException {
        try {
            ArrayList pipesSuppliers;
            Collection<B> filesToRead = MultiFileReaderUtils.getAllRemoteFilesToRead(this.config);
            ArrayList<B> sortedFiles = new ArrayList<B>(filesToRead);
            Bucket<B> bucket = this.config.getBucket();
            Collections.sort(sortedFiles, this.config.getFileOrder());
            if (this.config.isDownloadFirst()) {
                pipesSuppliers = MultiFileReaderUtils.downloadAndGetReadPipes(sortedFiles, bucket, this.config);
            } else {
                pipesSuppliers = new ArrayList();
                for (Object f : sortedFiles) {
                    pipesSuppliers.add(() -> {
                        SizedInputStream is = bucket.getAsStream(f);
                        return this.config.getPipeSupplier().get(is, f);
                    });
                }
            }
            return new ConcatPipe(pipesSuppliers);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

