/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.ConcatPipe;
import org.pipecraft.pipes.sync.source.StorageTxtFileReaderPipe;
import org.pipecraft.pipes.utils.PipeSupplier;

public class StorageMultiTxtFileReaderPipe<B>
extends CompoundPipe<String> {
    private final Storage<?, B> storage;
    private final String bucketName;
    private final String folderPath;
    private final Charset charset;
    private final int chunkSize;
    private final String fileRegex;
    private final Comparator<B> comparator;

    public StorageMultiTxtFileReaderPipe(Storage<?, B> storage, String bucket, String folderPath, Charset charset, int chunkSize, String fileRegex, Comparator<B> comparator) {
        this.storage = storage;
        this.bucketName = bucket;
        this.folderPath = folderPath;
        this.charset = charset;
        this.chunkSize = chunkSize;
        this.fileRegex = fileRegex;
        this.comparator = comparator;
    }

    public StorageMultiTxtFileReaderPipe(Storage<?, B> storage, String bucket, String folderPath, Comparator<B> comparator) {
        this(storage, bucket, folderPath, StandardCharsets.UTF_8, 0, ".*", comparator);
    }

    public StorageMultiTxtFileReaderPipe(Storage<?, B> storage, String bucket, String folderPath) {
        this(storage, bucket, folderPath, StandardCharsets.UTF_8, 0, ".*", new LexicographicOrder<B>(storage, bucket));
    }

    @Override
    protected Pipe<String> createPipeline() throws PipeException, InterruptedException {
        try {
            List pipeGenList = this.getPipeGenList();
            return new ConcatPipe<String>(pipeGenList);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    private List<PipeSupplier<String>> getPipeGenList() throws IOException {
        Object bucket = this.storage.getBucket(this.bucketName);
        ArrayList<B> blobs = new ArrayList<B>();
        ((Bucket)bucket).listFiles(this.folderPath, this.fileRegex).forEachRemaining(blobs::add);
        blobs.sort(this.comparator);
        ArrayList<PipeSupplier<String>> res = new ArrayList<PipeSupplier<String>>();
        for (Object b : blobs) {
            String path = ((Bucket)bucket).getPath(b);
            FileReadOptions options = new FileReadOptions().detectCompression(path);
            res.add(() -> new StorageTxtFileReaderPipe(this.storage, this.bucketName, path, this.charset, this.chunkSize, options));
        }
        return res;
    }

    private static class LexicographicOrder<T>
    implements Comparator<T> {
        private final Bucket<T> bucket;

        public LexicographicOrder(Storage<?, T> storage, String bucketName) {
            this.bucket = storage.getBucket(bucketName);
        }

        @Override
        public int compare(T b1, T b2) {
            String path1 = this.bucket.getPath(b1);
            String path2 = this.bucket.getPath(b2);
            return path1.compareTo(path2);
        }
    }
}

